/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Resource;
import com.xforceplus.event.dto.ResourceCodeChanged;
import com.xforceplus.event.model.EntityPreSaveEvent;
import com.xforceplus.jpa.listener.OperatorListener;
import java.util.Objects;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

public class ResourceListener
extends OperatorListener<Resource>
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(Resource entity) {
        EntityPreSaveEvent<ResourceCodeChanged> codeValidationEvent = new EntityPreSaveEvent<ResourceCodeChanged>(RevisionMetadata.RevisionType.INSERT, ResourceCodeChanged.builder().entity(entity).build());
        this.applicationEventPublisher.publishEvent(codeValidationEvent);
        if (entity.getIsServicePackage() == null) {
            entity.setIsServicePackage(false);
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        super.beforeInsert(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(Resource entity) {
        if (entity instanceof ManagedEntity) {
            boolean codeChanged;
            boolean appIdChanged;
            EntityEntry entityEntry = ((ManagedEntity)entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                appIdChanged = !Objects.equals(entityEntry.getLoadedValue("appId"), entity.getAppId());
                codeChanged = !Objects.equals(entityEntry.getLoadedValue("resourceCode"), entity.getResourceCode());
            } else {
                appIdChanged = entity.getAppId() != null;
                boolean bl = codeChanged = entity.getResourceCode() != null;
            }
            if (appIdChanged || codeChanged) {
                EntityPreSaveEvent<ResourceCodeChanged> codeValidationEvent = new EntityPreSaveEvent<ResourceCodeChanged>(RevisionMetadata.RevisionType.UPDATE, ResourceCodeChanged.builder().entity(entity).build());
                this.applicationEventPublisher.publishEvent(codeValidationEvent);
            }
        }
        super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(Resource entity) {
        entity.setApp(null);
        entity.setResourceApiRels(null);
        entity.setResourcesetResourceRels(null);
    }

    @PostLoad
    public void postLoad(Resource entity) {
        entity.postLoad();
    }
}

