/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Resourceset;
import com.xforceplus.jpa.listener.OperatorListener;
import io.geewit.utils.uuid.UUID;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.lang3.StringUtils;

public class ResourcesetListener
extends OperatorListener<Resourceset> {
    @PrePersist
    public void prePersist(Resourceset entity) {
        if (StringUtils.isBlank((CharSequence)entity.getResourcesetCode())) {
            entity.setResourcesetCode(UUID.randomUUID().toString());
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        super.beforeInsert(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(Resourceset entity) {
        super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(Resourceset entity) {
        entity.setResourcesetResourceRels(null);
        entity.setRoleResourcesetRels(null);
        entity.setServiceResourcesetRels(null);
    }

    @PostLoad
    public void postLoad(Resourceset entity) {
        entity.postLoad();
    }
}

