/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.RoleUserRel;
import com.xforceplus.event.model.EntityPostSaveEvent;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.PrePersist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

public class RoleUserRelListener
implements ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(RoleUserRelListener.class);
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(RoleUserRel entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setCreateId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setCreateName(authorizedUser.getOperaterName());
            } else {
                entity.setCreateName("");
            }
            Date now = Calendar.getInstance().getTime();
            entity.setCreateTime(now);
        }
        this.trail(RevisionMetadata.RevisionType.INSERT, entity);
    }

    public void trail(RevisionMetadata.RevisionType type, RoleUserRel entity) {
        EntityPostSaveEvent<RoleUserRel> entityTrailEvent = new EntityPostSaveEvent<RoleUserRel>(type, entity);
        try {
            this.applicationEventPublisher.publishEvent(entityTrailEvent);
        }
        catch (Exception e) {
            logger.error("tail publisher error", (Throwable)e);
        }
    }
}

