/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.ServicePackage;
import com.xforceplus.event.dto.ServicePackageCodeChanged;
import com.xforceplus.event.dto.ServicePackageNameChanged;
import com.xforceplus.event.model.EntityPreSaveEvent;
import com.xforceplus.jpa.listener.OperatorListener;
import io.geewit.utils.uuid.UUID;
import java.util.Objects;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

public class ServicePackageListener
extends OperatorListener<ServicePackage>
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(ServicePackage entity) {
        if (StringUtils.isBlank((CharSequence)entity.getServicePackageCode())) {
            entity.setServicePackageCode(UUID.randomUUID().toString());
        }
        EntityPreSaveEvent<ServicePackageCodeChanged> codeValidationEvent = new EntityPreSaveEvent<ServicePackageCodeChanged>(RevisionMetadata.RevisionType.INSERT, ServicePackageCodeChanged.builder().entity(entity).build());
        this.applicationEventPublisher.publishEvent(codeValidationEvent);
        EntityPreSaveEvent<ServicePackageNameChanged> nameValidationEvent = new EntityPreSaveEvent<ServicePackageNameChanged>(RevisionMetadata.RevisionType.INSERT, ServicePackageNameChanged.builder().entity(entity).build());
        this.applicationEventPublisher.publishEvent(nameValidationEvent);
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        super.beforeInsert(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(ServicePackage entity) {
        if (entity instanceof ManagedEntity) {
            boolean nameChanged;
            boolean appIdChanged;
            boolean codeChanged;
            EntityEntry entityEntry = ((ManagedEntity)entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                codeChanged = !Objects.equals(entityEntry.getLoadedValue("servicePackageCode"), entity.getServicePackageCode());
                appIdChanged = !Objects.equals(entityEntry.getLoadedValue("appId"), entity.getAppId());
                nameChanged = !Objects.equals(entityEntry.getLoadedValue("servicePackageName"), entity.getServicePackageName());
            } else {
                codeChanged = entity.getServicePackageCode() != null;
                appIdChanged = entity.getAppId() != null;
                boolean bl = nameChanged = entity.getServicePackageName() != null;
            }
            if (codeChanged) {
                EntityPreSaveEvent<ServicePackageCodeChanged> codeValidationEvent = new EntityPreSaveEvent<ServicePackageCodeChanged>(RevisionMetadata.RevisionType.UPDATE, ServicePackageCodeChanged.builder().entity(entity).build());
                this.applicationEventPublisher.publishEvent(codeValidationEvent);
            }
            if (appIdChanged || nameChanged) {
                EntityPreSaveEvent<ServicePackageNameChanged> nameValidationEvent = new EntityPreSaveEvent<ServicePackageNameChanged>(RevisionMetadata.RevisionType.UPDATE, ServicePackageNameChanged.builder().entity(entity).build());
                this.applicationEventPublisher.publishEvent(nameValidationEvent);
            }
        }
        super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(ServicePackage entity) {
        entity.setServiceResourcesetRels(null);
        entity.setCompanyServiceRels(null);
        entity.setApp(null);
    }

    @PostLoad
    public void postLoad(ServicePackage entity) {
        entity.postLoad();
    }
}

