/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Tenant;
import com.xforceplus.event.dto.TenantCodeChanged;
import com.xforceplus.event.dto.TenantNameChanged;
import com.xforceplus.event.model.EntityPostSaveEvent;
import com.xforceplus.event.model.EntityPreSaveEvent;
import com.xforceplus.jpa.listener.OperatorListener;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import io.geewit.utils.uuid.UUID;
import java.util.Objects;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

public class TenantListener
extends OperatorListener<Tenant>
implements ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(TenantListener.class);
    private ApplicationEventPublisher applicationEventPublisher;
    private final ThreadLocal<TenantNameChanged> tenantNameChangedThreadLocal = new ThreadLocal();

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(Tenant entity) {
        if (entity.getTenantId() == null) {
            long id = SnowflakeGenerator.id(Tenant.class);
            entity.setTenantId(id);
        }
        if (entity.getTenantCode() == null) {
            entity.setTenantCode(UUID.randomUUID().toString());
        }
        if (entity.getTenantDesc() == null && entity.getTenantName() != null) {
            entity.setTenantDesc(entity.getTenantName());
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        EntityPreSaveEvent<TenantCodeChanged> codeValidationEvent = new EntityPreSaveEvent<TenantCodeChanged>(RevisionMetadata.RevisionType.INSERT, TenantCodeChanged.builder().entity(entity).build());
        this.applicationEventPublisher.publishEvent(codeValidationEvent);
        EntityPreSaveEvent<TenantNameChanged> nameValidationEvent = new EntityPreSaveEvent<TenantNameChanged>(RevisionMetadata.RevisionType.INSERT, TenantNameChanged.builder().entity(entity).build());
        this.applicationEventPublisher.publishEvent(nameValidationEvent);
        super.beforeInsert(entity);
        this.cleanRelatedEntities(entity);
        this.trail(RevisionMetadata.RevisionType.INSERT, entity);
    }

    @PreUpdate
    public void preUpdate(Tenant entity) {
        if (entity instanceof ManagedEntity) {
            boolean nameChanged;
            boolean codeChanged;
            EntityEntry entityEntry = ((ManagedEntity)entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                codeChanged = !Objects.equals(entityEntry.getLoadedValue("tenantCode"), entity.getTenantCode());
                nameChanged = !Objects.equals(entityEntry.getLoadedValue("tenantName"), entity.getTenantName());
            } else {
                codeChanged = entity.getTenantCode() != null;
                boolean bl = nameChanged = entity.getTenantName() != null;
            }
            if (codeChanged) {
                EntityPreSaveEvent<TenantCodeChanged> codeValidationEvent = new EntityPreSaveEvent<TenantCodeChanged>(RevisionMetadata.RevisionType.UPDATE, TenantCodeChanged.builder().entity(entity).build());
                this.applicationEventPublisher.publishEvent(codeValidationEvent);
            }
            if (nameChanged) {
                TenantNameChanged tenantNameChanged = TenantNameChanged.builder().entity(entity).build();
                EntityPreSaveEvent<TenantNameChanged> nameValidationEvent = new EntityPreSaveEvent<TenantNameChanged>(RevisionMetadata.RevisionType.UPDATE, tenantNameChanged);
                this.applicationEventPublisher.publishEvent(nameValidationEvent);
                this.tenantNameChangedThreadLocal.set(tenantNameChanged);
            }
        }
        super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    @PostUpdate
    public void postUpdate(Tenant entity) {
        TenantNameChanged tenantNameChanged = this.tenantNameChangedThreadLocal.get();
        if (tenantNameChanged != null) {
            EntityPostSaveEvent<TenantNameChanged> nameValidationEvent = new EntityPostSaveEvent<TenantNameChanged>(RevisionMetadata.RevisionType.UPDATE, tenantNameChanged);
            this.applicationEventPublisher.publishEvent(nameValidationEvent);
        }
        this.trail(RevisionMetadata.RevisionType.UPDATE, entity);
        this.tenantNameChangedThreadLocal.remove();
    }

    private void cleanRelatedEntities(Tenant entity) {
        entity.setOrgs(null);
        entity.setUsers(null);
    }

    public void trail(RevisionMetadata.RevisionType type, Tenant entity) {
        EntityPostSaveEvent<Tenant> entityTrailEvent = new EntityPostSaveEvent<Tenant>(type, entity);
        try {
            this.applicationEventPublisher.publishEvent(entityTrailEvent);
        }
        catch (Exception e) {
            logger.error("tail publisher error", (Throwable)e);
        }
    }
}

