/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.tenant.security.core.context.ClientInfoHolder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.ICreater;
import com.xforceplus.tenant.security.core.domain.IUpdater;
import org.apache.commons.lang3.StringUtils;

public abstract class UpdaterListener<U extends IUpdater> {
    protected void beforeInsert(U entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setUpdaterId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setUpdaterName(authorizedUser.getOperaterName());
            }
            if (entity instanceof ICreater) {
                ((ICreater)entity).setCreaterId(String.valueOf(authorizedUser.getId()));
                if (authorizedUser.getOperaterName() != null) {
                    ((ICreater)entity).setCreaterName(authorizedUser.getOperaterName());
                } else {
                    ((ICreater)entity).setCreaterName("");
                }
            }
        } else {
            String clientId = ClientInfoHolder.get();
            if (StringUtils.isNotEmpty((CharSequence)clientId)) {
                entity.setUpdaterName(clientId);
                if (entity instanceof ICreater) {
                    ((ICreater)entity).setCreaterName(clientId);
                }
            }
        }
    }

    protected void beforeUpdate(U entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setUpdaterId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setUpdaterName(authorizedUser.getOperaterName());
            } else {
                entity.setUpdaterName("");
            }
        } else {
            String clientId = ClientInfoHolder.get();
            if (StringUtils.isNotEmpty((CharSequence)clientId)) {
                entity.setUpdaterName(clientId);
            }
        }
    }
}

