/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.User;
import com.xforceplus.jpa.listener.OperatorListener;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import java.util.Calendar;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserListener
extends OperatorListener<User> {
    private static final Logger logger = LoggerFactory.getLogger(UserListener.class);

    @PrePersist
    public void prePersist(User entity) {
        if (entity.getId() == null) {
            long id = SnowflakeGenerator.id(User.class);
            entity.setId(id);
        }
        if (entity.getUserPeriodTime() == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2030, 11, 31);
            entity.setUserPeriodTime(calendar.getTime());
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (entity.getActiveStatus() == null) {
            entity.setActiveStatus(1);
        }
        if (entity.getExpiredDate() == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2099, 11, 31);
            entity.setExpiredDate(calendar.getTime());
        }
        super.beforeInsert(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(User entity) {
        super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(User entity) {
        entity.setAccount(null);
        entity.setTenant(null);
        entity.setOrgs(null);
        entity.setRoleUserRels(null);
        entity.setOrgUserRels(null);
        entity.setUserApps(null);
        entity.setUserTags(null);
        entity.setOrgVirtualNodeUserRels(null);
    }

    @PostLoad
    public void postLoad(User entity) {
        entity.postLoad();
    }
}

