/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: TenantUserBo.java   2020-12-29 10-51-56
 * Author: Evan
 */
package com.xforceplus.bo.user;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.Set;

/**
 * <p>
 * Title: 根据租户查询用户列表
 * </p>
 * <p>
 * Description: 根据租户查询用户列表
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-12-29 10-51-56
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class TenantUserBo {

    /**
     * 查询类型
     */
    private Integer queryType;
    /**
     * 租户ID
     */
    private Long tenantId;
    /**
     *  租户ID集合查询
     */
    private Set<Long> tenantIds;
    /**
     * 用户状态(0.无效，1.有效的)
     */
    private Integer userStatus;

    /***
     * 用户类型 (0.管理员，1.普通)
     */
    private Integer userType;
    /**
     * 租户管理员角色Id
     */
    private Long adminRoleId;


    /**
     * 租户代码
     */
    private String  tenantCode;

    /**
     * 租户名称
     */
    private String  tenantName;


    /***
     * 用户创建时间-开始时间
     */
    private Date createdDateBegin;

    /***
     * 用户创建时间-结束时间
     */
    private Date createdDateEnd;
}
