package com.xforceplus.dao;

import com.xforceplus.entity.CompanyExtension;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author lengmz
 * @since 2020-07-16
 */
public interface CompanyExtensionDao extends JpaRepository<CompanyExtension, Long>, JpaSpecificationExecutor<CompanyExtension> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from CompanyExtension ce where ce.companyExtensionId = :id")
    void deleteById(@Param("id") Long id);

    @Modifying(clearAutomatically = true)
    @Query("delete from CompanyExtension ext where ext.companyId = :companyId")
    void deleteByCompanyId(@Param("companyId") long companyId);

    @Query("select ext from CompanyExtension ext where ext.companyId = :companyId and ext.extensionKey = :key")
    List<CompanyExtension> findByCompanyIdAndKey(@Param("companyId") long companyId, @Param("key") String extensionKey);
}
