package com.xforceplus.dao;

import com.xforceplus.entity.OrgVirtualNodeUserRel;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   duanhy
 * 创建时间: 2020/12/21 18:47
 * 功能描述:
 * 修改历史:
 */
public interface OrgVirtualUserRelDao extends JpaRepository<OrgVirtualNodeUserRel, Long>, JpaSpecificationExecutor<OrgVirtualNodeUserRel> {

    List<OrgVirtualNodeUserRel> findByOrgVirtualNodeId(Long nodeId);

    void deleteByTenantIdAndUserIdAndOrgVirtualNodeId(Long tenantId, Long userId, Long orgVirtualNodeId);

    Optional<OrgVirtualNodeUserRel> findByOrgVirtualNodeIdAndTenantIdAndUserId(Long nodeId, Long tenantId, Long userId);

    Optional<OrgVirtualNodeUserRel> findByOrgVirtualNodeIdAndUserId(Long nodeId, Long userId);

    Set<OrgVirtualNodeUserRel> findByOrgVirtualNodeIdIn(Set<Long> nodeId);

}
