package com.xforceplus.dao;

import com.xforceplus.entity.Resource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.*;
import org.springframework.data.repository.query.Param;

import java.util.Collection;
import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface ResourceDao extends JpaRepository<Resource, Long>, JpaSpecificationExecutor<Resource> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from Resource r where r.resourceId = :resourceId")
    void deleteById(@Param("resourceId") Long id);

    @EntityGraph(value = "Resource.graph", type = EntityGraph.EntityGraphType.FETCH)
    @Override
    Page<Resource> findAll(Specification<Resource> specification, Pageable pageable);

    List<Resource> findByParentId(long parentId);

    @Override
    List<Resource> findAll();

    @Modifying(clearAutomatically = true)
    @Query("update Resource r set r.status = :status where r.resourceId = :id")
    int updateStatus(@Param("id") long id, @Param("status") int status);

    /**
     * 根据AppId和资源码记录查询列表
     * @param appId        AppId
     * @param resourceCode ResourceCode
     * @return List<Resource>
     */
    List<Resource> findByAppIdAndResourceCode(Long appId, String resourceCode);

    @Query(value = "select sr.* from sys_resource sr "
        + "where sr.resource_id in ("
        + "select srrr.resource_id from sys_resourceset_resource_rel srrr "
        + "where srrr.resourceset_id in ("
        + "select srrr2.resouseset_id "
        + "from sys_role_resourceset_rel srrr2 "
        + "where srrr2.role_id = :roleId)) "
        + "and sr.status = 1",nativeQuery = true)
    List<Resource> findAllByRoleId(@Param("roleId")long roleId);

    @Query(value = "select sr.* from sys_resource sr "
        + "where sr.resource_id in ("
        + "select srrr.resource_id from sys_resourceset_resource_rel srrr "
        + "where srrr.resourceset_id in ("
        + "select srrr2.resouseset_id "
        + "from sys_role_resourceset_rel srrr2 "
        + "where srrr2.role_id in :roleIds)) "
        + "and sr.status = 1",nativeQuery = true)
    List<Resource> findAllByRoleIds(@Param("roleIds") Collection<Long> roleIds);

    @Query(value = "select * from sys_resource where resource_id in(SELECT" +
            " DISTINCT r.resource_id" +
            " FROM" +
            " sys_resource AS r" +
            " INNER JOIN sys_resourceset_resource_rel AS rel ON r.resource_id = rel.resource_id" +
            " INNER JOIN sys_resourceset AS rs ON rel.resourceset_id = rs.resourceset_id" +
            " WHERE" +
            " rs.resourceset_id IN (:resourcesetIds) and r.`status` = 1 and rs.`status` = 1)",nativeQuery = true)
    List<Resource> findByResourcesetIds(@Param("resourcesetIds") Collection<Long> resourcesetIds);
}
