package com.xforceplus.dao;

import com.xforceplus.entity.Resourceset;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.Collection;
import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface ResourcesetDao extends JpaRepository<Resourceset, Long>, JpaSpecificationExecutor<Resourceset> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from Resourceset rs where rs.resourcesetId = :resourcesetId")
    void deleteById(@Param("resourcesetId") Long id);

    @Query("select rs.resourcesetId from Resourceset rs where rs.resourcesetCode = :resourcesetCode")
    Long findByResourcesetCode(@Param("resourcesetCode") String resourcesetCode);

    @Query("select count(rs) from Resourceset rs where rs.resourcesetId <> :resourcesetId and rs.resourcesetCode = :resourcesetCode")
    long countByNotCurrentResourcesetIdAndCode(@Param("resourcesetId") long resourcesetId, @Param("resourcesetCode") String resourcesetCode);

    @Query("select count(rs) from Resourceset rs where rs.resourcesetId <> :resourcesetId and rs.resourcesetName = :resourcesetName")
    long countByNotCurrentResourcesetIdAndName(@Param("resourcesetId") long resourcesetId, @Param("resourcesetName") String resourcesetName);

    /***
     * 按Code
     * @param resourceSetCode resourceSetCode
     * @return List<Resourceset>
     */
    @Query("select ten from Resourceset ten where ten.resourcesetCode = :resourceSetCode")
    List<Resourceset> findByCode(@Param("resourceSetCode") String resourceSetCode);

    @Query(value = "select rel.resourceset_id from bss_service_resourceset_rel rel LEFT JOIN bss_service_package sp ON sp.service_package_id = rel.service_package_id where rel.service_package_id in (:packageIds) and sp.status = 1", nativeQuery = true)
    List<Long> findResourcesetIdsByPackageIds(@Param("packageIds") Collection<Long> packageIds);

    /***
     * 根据ID查询数据是否存在；
     * @param resourceSetIds  Ids列表
     * @return List<Resourceset>  批量查询列表
     */
    @Query(value = "from Resourceset where resourcesetId in(:resourceSetIds) ")
    List<Resourceset> findByResourceSetIds(@Param("resourceSetIds") List<Long> resourceSetIds);
}
