package com.xforceplus.dao;

import com.xforceplus.entity.RoleUserRel;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface RoleUserRelDao extends JpaRepository<RoleUserRel, Long>, JpaSpecificationExecutor<RoleUserRel> {
    @Override
    List<RoleUserRel> findAll();

    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from RoleUserRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    @Modifying(clearAutomatically = true)
    @Query("delete from RoleUserRel rel where rel.userId = :userId and rel.roleId = :roleId")
    void deleteByUserIdAndRoleId(@Param("userId") long userId, @Param("roleId") long roleId);

    List<RoleUserRel> findByRoleId(long roleId);

    List<RoleUserRel> findByUserId(long userId);

    @Modifying(clearAutomatically = true)
    @Query("delete from RoleUserRel rel where rel.tenantId = :tenantId and rel.userId = :userId and rel.roleId = :roleId")
    void deleteByTenantIdAndUserIdAndRoleId(@Param("tenantId") long tenantId, @Param("userId") long userId, @Param("roleId") Long roleId);

    @Modifying(clearAutomatically = true)
    @Query("delete from RoleUserRel rel where rel.userId = :userId")
    void deleteByUserId(@Param("userId") long userId);

    @Modifying(clearAutomatically = true)
    @Query("delete from RoleUserRel rel where rel.roleId = :roleId")
    void deleteByRoleId(@Param("roleId") long roleId);

    long countByRoleId(long roleId);

    List<RoleUserRel> findByTenantId(Long tenantId);

    @Modifying(flushAutomatically = true)
    @Query("update RoleUserRel rel set rel.tenantId = :tenantId where rel.id in (:roleUserRelIds)")
    void batchUpdateTenant(@Param("roleUserRelIds") List<Long> roleUserRelIds, @Param("tenantId")Long tenantId);}
