package com.xforceplus.dao;

import com.xforceplus.entity.ServiceApi;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.*;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface ServiceApiDao extends JpaRepository<ServiceApi, Long>, JpaSpecificationExecutor<ServiceApi> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from ServiceApi s where s.serviceApiId = :id")
    void deleteById(@Param("id") Long id);

    @Override
    @EntityGraph(value = "ServiceApi.graph", type = EntityGraph.EntityGraphType.FETCH)
    Page<ServiceApi> findAll(Specification<ServiceApi> specification, Pageable pageable);

    //@QueryHints({ @QueryHint(name = "org.hibernate.cacheable", value ="true") })
    //Iterable<ServiceApi> findAll();

    List<ServiceApi> findByServiceApiId(long id);

    List<ServiceApi> findBySkipCheckEqualsAndStatusEquals(Boolean skipCheck, Integer status);

    @Query("select distinct sa from ServiceApi sa,ResourceApiRel rar,Resource r where " +
            "sa.serviceApiId = rar.serviceApiId and rar.resourceId = r.resourceId and  r.resourceCode = :resourceCode")
    List<ServiceApi> findServiceApiUrlsByResourceCode(@Param("resourceCode") String resourceCode);

    /**
     * 根据RouteId,serviceApiPath,RequestMethod 查询数据
     * @param routeId   routeId
     * @param serviceApiUrl serviceApiUrl
     * @param requestMethod requestMethod
     * @return List<ServiceApi>
     */
    List<ServiceApi> findByRouteIdAndServiceApiUrlAndRequestMethod(Long routeId, String serviceApiUrl, RequestMethod requestMethod);
}
