package com.xforceplus.dao;

import com.xforceplus.entity.SettleFlowPackage;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface SettleFlowPackageDao extends JpaRepository<SettleFlowPackage, Long>, JpaSpecificationExecutor<SettleFlowPackage> {

    @Override
    @EntityGraph(value = "SettleFlowPackage.graph", type = EntityGraph.EntityGraphType.FETCH)
    Page<SettleFlowPackage> findAll(Specification<SettleFlowPackage> spec, Pageable pageable);


    List<SettleFlowPackage> findByFlowId(@Param("flowId") long flowId);
}
