package com.xforceplus.dao;

import com.xforceplus.entity.Tenant;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Set;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface TenantDao extends JpaRepository<Tenant, Long>, JpaSpecificationExecutor<Tenant> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from Tenant t where t.tenantId = :tenantId")
    void deleteById(@Param("tenantId") Long id);

    //@QueryHints({ @QueryHint(name = "org.hibernate.cacheable", value ="true") })
    @Override
    List<Tenant> findAll();

    @Query("select ten.tenantId from Tenant ten where ten.tenantCode = :tenantCode")
    List<Long> findByTenantCode(@Param("tenantCode") String tenantCode);

    /**
     * 根据用户名称查询租户IDS
     * @param tenantName 租户名称
     * @return List<Long> 租户ID集合
     */
    @Query("select ten.tenantId from Tenant ten where ten.tenantName like :tenantName")
    Set<Long> findIdsByTenantName(@Param("tenantName") String tenantName);

    Tenant findByTenantName(String tenantName);

    @Query("select ten.tenantName from Tenant ten where ten.tenantId = :tenantId")
    String findTenantNameByTenantId(@Param("tenantId") long tenantId);
}
