package com.xforceplus.dao;

import com.xforceplus.entity.UserApp;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Set;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface UserAppDao extends JpaRepository<UserApp, Long>, JpaSpecificationExecutor<UserApp> {
    @Query("select ua.appId from UserApp ua where ua.userId = :userId")
    Set<Long> findAppIdByUserId(@Param("userId") long userId);

    @Query("select ua from UserApp ua where ua.userId = :userId")
    List<UserApp> findByUserId(@Param("userId") long userId);

    @Modifying(clearAutomatically = true)
    @Query("delete from UserApp ua where ua.userId = :userId")
    void deleteByUserId(@Param("userId") Long userId);
}
