package com.xforceplus.dao.impl;

import com.xforceplus.dao.CompanyServiceRelDao;
import com.xforceplus.dao.ServiceResourcesetRelDao;
import org.hibernate.internal.SessionImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

@SuppressWarnings({"all"})
@Service
public class BatchServiceDaoImpl {
    @PersistenceContext
    private EntityManager em;

    @Autowired
    private ServiceResourcesetRelDao serviceResourcesetRelDao;

    @Autowired
    private CompanyServiceRelDao companyServiceRelDao;


    @Transactional(rollbackFor = RuntimeException.class)
    public void saveList(List<com.xforceplus.entity.ServiceResourcesetRel> list) throws SQLException {
        if (list == null || list.isEmpty()) {
            return;
        }
        int size = list.size();
        Connection connection = em.unwrap(SessionImpl.class).connection();
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("正在保存第：" + i + "条数据*************************************");
            em.persist(list.get(i));
            if (i % 10000 == 0 || i == list.size()) {
                em.flush();
                em.clear();
                connection.commit();
            }
        }
    }

    public void deletePackageRelResourcesetByPackageId(Long servicePackageId) {
        serviceResourcesetRelDao.deleteByPackageId(servicePackageId);
    }

    public void deleteCompanyPackageByPackageIdAndTenantId(Long packageId, Long tenantId) {
        companyServiceRelDao.deleteCompanyPackageByPackageIdAndTenantId(packageId, tenantId);
    }
}
