package com.xforceplus.dao.impl;

import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.api.utils.Separator;
import com.xforceplus.dao.CustomizedOrgVirtualNodeDao;
import com.xforceplus.data.transform.UnderlineToBeanResultTransformer;
import com.xforceplus.domain.orgVirtual.OrgVirtualTreeNode;
import com.xforceplus.entity.OrgVirtualNode;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.List;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   duanhy
 * 创建时间: 2020/12/23 10:57
 * 功能描述:
 * 修改历史:
 */
public class CustomizedOrgVirtualNodeDaoImpl implements CustomizedOrgVirtualNodeDao {

    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<OrgVirtualTreeNode> treeNodeList(Long tenantId, Long typeId) {
        StringBuilder selectBuilder = new StringBuilder("select DISTINCT " +
                " a.org_virtual_node_id as `key`" +
                ", b.org_code as orgCode" +
                ", b.org_name as orgName" +
                ", b.short_name as shortName" +
                ", b.org_desc as orgDesc" +
                ", a.parent_id as pid" +
                " from sys_org_virtual_node a " +
                " left join sys_org_virtual b on a.org_virtual_id=b.org_virtual_id " +
                " where a.tenant_id=:tenantId " +
                " and a.node_type_id=:typeId ");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", tenantId);
        selectQuery.setParameter("typeId", typeId);
        return selectQuery.unwrap(NativeQuery.class)
                .addScalar("key", StandardBasicTypes.LONG)
                .addScalar("orgCode", StandardBasicTypes.STRING)
                .addScalar("orgName", StandardBasicTypes.STRING)
                .addScalar("shortName", StandardBasicTypes.STRING)
                .addScalar("orgDesc", StandardBasicTypes.STRING)
                .addScalar("pid", StandardBasicTypes.LONG)
                .setResultTransformer(Transformers.aliasToBean(OrgVirtualTreeNode.class))
                .getResultList();
    }

    @Override
    public List<OrgVirtualModel.Response.Model> listByUserId(Long typeId, Long userId, Long tenantId) {
        StringBuilder selectBuilder = new StringBuilder("SELECT " +
                " b.org_virtual_node_id, " +
                " b.parent_id, " +
                " b.parent_ids, " +
                " c.control_flag, " +
                " a.* " +
                " FROM " +
                " sys_org_virtual a " +
                " LEFT JOIN sys_org_virtual_node b ON a.org_virtual_id = b.org_virtual_id " +
                " LEFT JOIN sys_org_virtual_node_user_rel c ON b.org_virtual_node_id = c.org_virtual_node_id " +
                " WHERE " +
                " b.node_type_id =:typeId " +
                " AND c.user_id =:userId " +
                " AND a.tenant_id =:tenantId" +
                " order by b.parent_ids");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", tenantId);
        selectQuery.setParameter("typeId", typeId);
        selectQuery.setParameter("userId", userId);

        AliasToBeanResultTransformer transformer = new UnderlineToBeanResultTransformer(OrgVirtualModel.Response.Model.class);
        return selectQuery.unwrap(NativeQueryImpl.class)
                .setResultTransformer(transformer)
                .getResultList();
    }

    @Override
    public List<OrgVirtualModel.Response.Model> listByNodeId(OrgVirtualNode node) {
        StringBuilder selectBuilder = new StringBuilder("SELECT " +
                " b.org_virtual_node_id, " +
                " b.parent_id, " +
                " b.parent_ids, " +
                " b.node_type_id, " +
                " a.* " +
                " FROM " +
                " sys_org_virtual a " +
                " LEFT JOIN sys_org_virtual_node b ON a.org_virtual_id = b.org_virtual_id " +
                " WHERE " +
                " a.tenant_id =:tenantId " +
                " AND b.parent_ids LIKE :parentIds" +
                " order by b.parent_ids");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", node.getTenantId());
        selectQuery.setParameter("parentIds", node.getParentIds() + Separator.LIKE);

        AliasToBeanResultTransformer transformer = new UnderlineToBeanResultTransformer(OrgVirtualModel.Response.Model.class);
        return selectQuery.unwrap(NativeQueryImpl.class)
                .setResultTransformer(transformer)
                .getResultList();
    }
}
