package com.xforceplus.dao.impl;

import com.xforceplus.bo.org.OrgCompanyQueryBo;
import com.xforceplus.bo.org.OrgUserStatisticsQueryBo;
import com.xforceplus.dao.OrgExtendDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.dto.org.OrgCompanyDTO;
import com.xforceplus.dto.org.OrgParentDTO;
import com.xforceplus.dto.org.OrgUserStatisticsDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * @Author: HWT
 * @Date: 2020/11/10 11:35
 */
@Slf4j
@Repository
@SuppressWarnings("all")
public class OrgExtendDaoImpl extends AbstractDefaultJpaRepositoryImpl implements OrgExtendDao{

  @Override
  @Transactional(readOnly = true)
  public  List<OrgDto> getOrgByTenantCodeAndOrgCode(String tenantCode, String orgCode) {
    StringQuery query =
            StringQuery.builder()
                    .query("select  sos.org_struct_id as org_id from bss_tenant bt \n"
                            + "inner join sys_org_struct sos on sos.tenant_id = bt.tenant_id \n"
                            + " where 1=1 and sos.status = 1 ")
                    .predicateNotNull(tenantCode)
                    .query(" and bt.tenant_code = :tenantCode ")
                    .param("tenantCode", tenantCode)
                    .predicateNotNull(orgCode)
                    .query(" and sos.org_code = :orgCode ")
                    .param("orgCode", orgCode)
                    .build();
    return this.findBySql(query, OrgDto.class, Boolean.TRUE);
  }


  /**
   * 根据税号查询
   *
   * @param queryBo 查询参数
   * @return List<OrgCompanyDTO>
   */
  @Override
  public List<OrgCompanyDTO> findOrgCompanyByTaxNum(OrgCompanyQueryBo queryBo) {
    Assert.hasText(queryBo.getTaxNum(), "公司税号不能为空");
    StringQuery stringQuery = StringQuery.builder().query("select sos.tenant_id,sos.company_id,bc.company_code,bc.company_name,bc.tax_num,sos.org_struct_id as orgId,sos.org_name, " +
            "  sos.org_code from  sys_org_struct  sos,bss_company  bc  " +
            "  where   sos.company_id=bc.company_id and  bc.tax_num=:taxNum  ")
            .param("taxNum", queryBo.getTaxNum())
            .predicateNotNull(queryBo.getCompanyId())
            .query(" and  bc.company_id=:companyId ")
            .param("companyId", queryBo.getCompanyId())

            .predicateNotNull(queryBo.getOrgId())
            .query(" and  sos.org_struct_id=:orgId ")
            .param("orgId", queryBo.getOrgId())

            .predicateNotNull(queryBo.getTenantId())
            .query(" and  sos.tenant_id=:tenantId ")
            .param("tenantId", queryBo.getTenantId())
            .predicate(true)
            .query(" order by sos.org_struct_id desc ");
    return this.findBySql(stringQuery, OrgCompanyDTO.class, Boolean.TRUE);
  }


  /**
   * 查询每个组织组织用户数据统计
   *
   * @param queryBo 查询对象
   * @return List<OrgUserStatisticsDTO>
   */
  @Override
  public List<OrgUserStatisticsDTO> findUserStatisticsByOrgIds(OrgUserStatisticsQueryBo queryBo) {
    Assert.notEmpty(queryBo.getOrgIds(), "组织ID列表不能为空");
    log.info("OrgUserStatisticsQueryBo:{}", queryBo.toString());
    StringQuery stringQuery = StringQuery.builder()
            .query(" select ur.org_struct_id as org_id,count(*) as user_total_num ")
            .query(" from sys_org_user_rel ur where org_struct_id IN(:orgIds) ")
            .predicate(true)
            .inParam("orgIds", queryBo.getOrgIds())
            .predicateNotNull(queryBo.getTenantId())
            .query("  and  ur.tenant_id=:tenantId ")
            .param("tenantId", queryBo.getTenantId())
            .predicate(true)
            .query(" group by ur.org_struct_id ")
            .build();
    return super.findBySql(stringQuery, OrgUserStatisticsDTO.class, Boolean.TRUE);
  }


  /**
   * 查询父组组织信息
   *
   * @param orgIds 组织ID列表
   * @return List<OrgParentDTO> 父组组织信息
   */
  @Override
  public List<OrgParentDTO> findOrgParentByOrgIds(List<Long> orgIds) {
    Assert.notEmpty(orgIds, "组织ID列表不能为空");
    StringQuery stringQuery = StringQuery
            .builder()
            .query("select org_struct_id as org_id ,org_name from sys_org_struct where org_struct_id in (:orgIds)")
            .inParam("orgIds", orgIds)
            .build();
    return super.findBySql(stringQuery, OrgParentDTO.class, Boolean.TRUE);
  }
}