/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: RoleExtendDao.java   2020-12-22 09-52-36
 * Author: Evan
 */
package com.xforceplus.dao.role.impl;

import com.xforceplus.dao.role.RoleExtendDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.domain.tenant.RoleResourceDTO;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

import java.util.List;

/**
 * <p>
 * Title: 角色扩展查询
 * </p>
 * <p>
 * Description: 角色扩展查询
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-12-22 09-52-36
 * @since V1.0
 */
@Repository
public class RoleExtendImplDao  extends AbstractDefaultJpaRepositoryImpl implements RoleExtendDao {

    /**
     * 按角色ID查询角色关系功能集 (返回数据有重复的功能集)
     * @param roleId 角色ID
     * @param status 状态
     * @return List<RoleResourceDTO>
     */
    @Override
    public List<RoleResourceDTO> findResourceSetByRoleId(Long roleId, Integer status) {
        Assert.notNull(roleId,"角色Id不为空");
        Assert.notNull(status,"状态不为空");
        StringQuery query = StringQuery.builder()
                .query(" select  srs.resourceset_id   resource_set_id,srs.resourceset_code   `itemCode`,srs.resourceset_name  `itemName`, srs.`status`,srs.role_id  " +
                        "  from sys_resourceset srs INNER JOIN " +
                        " sys_role_resourceset_rel srrr on   srs.resourceset_id=srrr.resouseset_id " +
                        " where  srrr.role_id=:roleId and srs.`status`=:status ")
                .predicate(true)
                .param("roleId", roleId)
                .param("status",status)
                .build();
        return this.findBySql(query,RoleResourceDTO.class,Boolean.TRUE);
    }
}
