/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: UserExtendDao.java   2020-12-28 16-27-14
 * Author: Evan
 */
package com.xforceplus.dao.user;

import com.xforceplus.bo.user.OrgUserBO;
import com.xforceplus.bo.user.OrgUserComplexBO;
import com.xforceplus.dto.user.OrgUserDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.NoRepositoryBean;

/**
 * <p>
 * Title: 用户与组织查询条件
 * </p>
 * <p>
 * Description: 用户与组织查询条件
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-12-28 16-27-14
 * @since V1.0
 */
@NoRepositoryBean
public interface OrgUserExtendDao {


    /**
     *  查询当前节点的用户
     *  @param pageable {@link Pageable}
     * @param orgUserBO  OrgUserBO
     * @return  Page<OrgUserDTO>
     */
    Page<OrgUserDTO> pageByCurrentOrg(Pageable pageable, OrgUserBO orgUserBO);

    /**
     * 复杂条件查询当前节点的用户及以下用户
     * @param pageable {@link Pageable}
     * @param orgUserBO 查询条件
     * @return   Page<OrgUserDTO>
     */
    Page<OrgUserDTO> pageByBelongOrg(Pageable pageable,OrgUserBO orgUserBO);

    /**
     *  查询当前节点的用户
     *  @param pageable {@link Pageable}
     * @param orgUserBO  OrgUserComplexBO
     * @return   Page<OrgUserDTO>
     */
    Page<OrgUserDTO> pageByCurrentOrgQueryType(Pageable pageable, OrgUserComplexBO orgUserBO);
    /**
     * 复杂条件查询当前节点的用户及以下用户
     * @param pageable {@link Pageable}
     * @param orgUserBO 查询条件
     * @return   Page<OrgUserDT
            *
            *
            *
            *
     */
    Page<OrgUserDTO> pageByBelongOrgQueryType(Pageable pageable, OrgUserComplexBO orgUserBO);
}
