/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: UnderlineToBeanUtils.java   2020-10-20 10-32-33
 * Author: Evan
 */
package com.xforceplus.data.transform;


import org.springframework.util.StringUtils;

import static com.xforceplus.api.utils.Separator.EMPTY;
import static com.xforceplus.api.utils.Separator.UNDERLINE;


/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-20 10-32-33
 * @since V1.0
 */
public class UnderlineToBeanUtils {




    public static String camelToUnderline(final String param, final Boolean upper) {
        if (StringUtils.isEmpty(param)) {
            return EMPTY;
        }
        final int len = param.length();
        final StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; i++) {
            final char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append(UNDERLINE);
                sb.append(Character.toLowerCase(c));
            } else {
                sb.append(c);
            }
        }
        return upper ? sb.toString().toUpperCase() : sb.toString().toLowerCase();
    }

    /**
     * 下划线转驼峰
     * @param param String
     * @return String String
     */
    public static String underlineToCamel(final String param) {
        final StringBuilder result = new StringBuilder();
        if (StringUtils.hasText(param)) {
            final String text = param.trim().toLowerCase();
            for (int i = 0; i < text.length(); i++) {
                final char c = text.charAt(i);
                if (c != UNDERLINE.charAt(0)) {
                    if (i > 0 && Character.toUpperCase(text.charAt(i - 1)) == UNDERLINE.charAt(0)) {
                        result.append(Character.toUpperCase(text.charAt(i)));
                    } else {
                        result.append(c);
                    }
                }
            }
        }
        return result.toString();

    }
}
