package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.jpa.listener.CompanyListener;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.envers.Audited;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({CompanyListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_company")
public class Company extends CompanyDto<Tenant, CompanyExtension> implements Serializable {
    @JsonIgnore
    private List<OrgStruct> orgs;

    @JsonView(View.Info.class)
    private List<String> companyNos;

    @JsonView(View.Info.class)
    private OrgStruct parentOrg;


    @Override
    @Id
    @Column(name = "company_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getCompanyId() {
        return companyId;
    }

    @Override
    @NotNull
    @Basic
    @Column(name = "company_code", nullable = false)
    public String getCompanyCode() {
        return companyCode;
    }

    @Override
    @NotNull
    @Audited
    @Basic
    @Column(name = "company_name", nullable = false)
    public String getCompanyName() {
        return companyName;
    }

    @Override
    @NotNull
    @Audited
    @Basic
    @Column(name = "tax_num")
    public String getTaxNum() {
        return taxNum;
    }

    @Override
    @Basic
    @Column(name = "location_area")
    public String getLocationArea() {
        return locationArea;
    }

    @Override
    @Basic
    @Column(name = "location_city")
    public String getLocationCity() {
        return locationCity;
    }

    @Override
    @Basic
    @Column(name = "location_addr")
    public String getLocationAddr() {
        return locationAddr;
    }

    @Override
    @Basic
    @Column(name = "company_phone")
    public String getCompanyPhone() {
        return companyPhone;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "business_start_time")
    public Date getBusinessStartTime() {
        return businessStartTime;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "business_end_time")
    public Date getBusinessEndTime() {
        return businessEndTime;
    }

    @Override
    @Basic
    @Column(name = "business_time_long")
    public Integer getBusinessTimeLong() {
        return businessTimeLong;
    }

    @Override
    @Basic
    @Column(name = "business_scope")
    public String getBusinessScope() {
        return businessScope;
    }

    @Override
    @Basic
    @Column(name = "company_logo")
    public String getCompanyLogo() {
        return companyLogo;
    }

    @Override
    @Basic
    @Column(name = "business_license")
    public String getBusinessLicense() {
        return businessLicense;
    }

    @Override
    @Basic
    @Column(name = "plat_manager_status")
    public Integer getPlatManagerStatus() {
        return platManagerStatus;
    }

    @Override
    @Basic
    @Column(name = "manager_location")
    public String getManagerLocation() {
        return managerLocation;
    }

    @Override
    @Basic
    @Column(name = "manager_name")
    public String getManagerName() {
        return managerName;
    }

    @Override
    @Basic
    @Column(name = "manager_card_type")
    public String getManagerCardType() {
        return managerCardType;
    }

    @Override
    @Basic
    @Column(name = "manager_id_card")
    public String getManagerIdCard() {
        return managerIdCard;
    }

    @Override
    @Basic
    @Column(name = "manager_phone")
    public String getManagerPhone() {
        return managerPhone;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "manager_id_card_start_time")
    public Date getManagerIdCardStartTime() {
        return managerIdCardStartTime;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "manager_id_card_end_time")
    public Date getManagerIdCardEndTime() {
        return managerIdCardEndTime;
    }

    @Override
    @Basic
    @Column(name = "manager_id_card_time_long")
    public Integer getManagerIdCardTimeLong() {
        return managerIdCardTimeLong;
    }

    @Override
    @Basic
    @Column(name = "manager_id_card_front_photo")
    public String getManagerIdCardFrontPhoto() {
        return managerIdCardFrontPhoto;
    }

    @Override
    @Basic
    @Column(name = "manager_id_card_back_photo")
    public String getManagerIdCardBackPhoto() {
        return managerIdCardBackPhoto;
    }

    @Override
    @Basic
    @Column(name = "bank_name")
    public String getBankName() {
        return bankName;
    }

    @Override
    @Basic
    @Column(name = "bank_branch_name")
    public String getBankBranchName() {
        return bankBranchName;
    }

    @Override
    @Basic
    @Column(name = "bank_no")
    public String getBankNo() {
        return bankNo;
    }

    @Override
    @Basic
    @Column(name = "bank_area")
    public String getBankArea() {
        return bankArea;
    }

    @Override
    @Basic
    @Column(name = "bank_city")
    public String getBankCity() {
        return bankCity;
    }

    @Override
    @Basic
    @Column(name = "operate_reason")
    public String getOperateReason() {
        return operateReason;
    }

    @Override
    @Basic
    @Column(name = "tradition_authen_flag")
    public Integer getTraditionAuthenFlag() {
        return traditionAuthenFlag;
    }

    @Override
    @Basic
    @Column(name = "inspection_service_flag")
    public Integer getInspectionServiceFlag() {
        return inspectionServiceFlag;
    }

    @Override
    @Basic
    @Column(name = "speed_inspection_channel_flag")
    public Integer getSpeedInspectionChannelFlag() {
        return speedInspectionChannelFlag;
    }

    @Override
    @Basic
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "cquota", precision = 2)
    public BigDecimal getCquota() {
        return cquota;
    }

    @Override
    @Basic
    @Column(name = "squota", precision = 2)
    public BigDecimal getSquota() {
        return squota;
    }

    @Override
    @Basic
    @Column(name = "ce_quota", precision = 2)
    public BigDecimal getCeQuota() {
        return ceQuota;
    }

    @Override
    @Basic
    @Column(name = "ju_quota", precision = 2)
    public BigDecimal getJuQuota() {
        return juQuota;
    }

    @Override
    @Basic
    @Column(name = "se_quota", precision = 2)
    public BigDecimal getSeQuota() {
        return seQuota;
    }

    @Override
    @Basic
    @Column(name = "regist_location_area")
    public String getRegistLocationArea() {
        return registLocationArea;
    }

    @Override
    @Basic
    @Column(name = "regist_location_city")
    public String getRegistLocationCity() {
        return registLocationCity;
    }

    @Override
    @Basic
    @Column(name = "regist_location_addr")
    public String getRegistLocationAddr() {
        return registLocationAddr;
    }

    @Override
    @Basic
    @Column(name = "taxpayer_qualification_type")
    public Integer getTaxpayerQualificationType() {
        return taxpayerQualificationType;
    }

    @Override
    @Basic
    @Column(name = "taxpayer_qualification")
    public String getTaxpayerQualification() {
        return taxpayerQualification;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_name")
    public String getProxyManagerName() {
        return proxyManagerName;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_card_type")
    public String getProxyManagerCardType() {
        return proxyManagerCardType;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_id_card")
    public String getProxyManagerIdCard() {
        return proxyManagerIdCard;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_phone")
    public String getProxyManagerPhone() {
        return proxyManagerPhone;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "proxy_manager_id_card_start_time")
    public Date getProxyManagerIdCardStartTime() {
        return proxyManagerIdCardStartTime;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "proxy_manager_id_card_end_time")
    public Date getProxyManagerIdCardEndTime() {
        return proxyManagerIdCardEndTime;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_id_card_time_long")
    public Integer getProxyManagerIdCardTimeLong() {
        return proxyManagerIdCardTimeLong;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_id_card_front_photo")
    public String getProxyManagerIdCardFrontPhoto() {
        return proxyManagerIdCardFrontPhoto;
    }

    @Override
    @Basic
    @Column(name = "proxy_manager_id_card_back_photo")
    public String getProxyManagerIdCardBackPhoto() {
        return proxyManagerIdCardBackPhoto;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    @Audited
    @Temporal(TemporalType.DATE)
    @Column(name = "effective_date")
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    @Override
    @Audited
    @Basic
    @Column(name = "is_effective")
    public Boolean getEffective() {
        return effective;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "company")
    public List<OrgStruct> getOrgs() {
        return orgs;
    }

    public void setOrgs(List<OrgStruct> orgs) {
        this.orgs = orgs;
    }



    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Company company = (Company) o;
        return Objects.equals(super.companyId, company.companyId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), super.companyId);
    }

    @Transient
    public List<String> getCompanyNos() {
        return companyNos;
    }

    public void setCompanyNos(List<String> companyNos) {
        this.companyNos = companyNos;
    }

    @Transient
    public OrgStruct getParentOrg() {
        return parentOrg;
    }

    public void setParentOrg(OrgStruct parentOrg) {
        this.parentOrg = parentOrg;
    }
}
