package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_role_resourceset_rel")
public class RoleResourcesetRel implements Serializable {
    private Long id;
    private Long roleId;
    private Long resousesetId;
    private Long tenantId;

    @JsonIgnore
    private Resourceset resourceset;

    @JsonIgnore
    private Role role;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Basic
    @Column(name = "role_id", nullable = false)
    public Long getRoleId() {
        return (roleId != null && roleId > 0) ? roleId : null;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    @Basic
    @Column(name = "resouseset_id", nullable = false)
    public Long getResousesetId() {
        return (resousesetId != null && resousesetId > 0) ? resousesetId : null;
    }

    public void setResousesetId(Long resousesetId) {
        this.resousesetId = resousesetId;
    }

    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "resouseset_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Resourceset getResourceset() {
        return resourceset;
    }

    public void setResourceset(Resourceset resourceset) {
        this.resourceset = resourceset;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "role_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Role getRole() {
        return role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RoleResourcesetRel that = (RoleResourcesetRel) o;
        return roleId.equals(that.roleId) &&
                resousesetId.equals(that.resousesetId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(roleId, resousesetId);
    }

    @Override
    public String toString() {
        return "RoleResourcesetRel{" +
                "id=" + id +
                ", roleId=" + roleId +
                ", resousesetId=" + resousesetId +
                ", tenantId=" + tenantId +
                '}';
    }
}
