package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.geewit.web.utils.JsonUtils;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;


/**
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "settle_flow")
public class SettleFlow implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(SettleFlow.class);

    private Long flowId;
    private String flowCode;
    private String flowName;
    private Long tenantId;
    private String tenantCode;
    private Boolean needStep;
    private SettleStep settleStep;
    private String rawProperties;
    private String script;
    private List<SettleTemplate> templates;
    private List<Long> packageIds;

    @Id
    @Column(name = "flow_id")
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getFlowId() {
        return flowId;
    }

    @Basic
    @Column(name = "flow_code")
    public String getFlowCode() {
        return flowCode;
    }

    @Basic
    @Column(name = "flow_name")
    public String getFlowName() {
        return flowName;
    }

    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return tenantId;
    }

    @Basic
    @Column(name = "tenant_code")
    public String getTenantCode() {
        return tenantCode;
    }

    @Basic
    @Column(name = "need_step")
    public Boolean getNeedStep() {
        return needStep;
    }

    @JsonIgnore
    @Basic
    @Column(name = "properties")
    public String getRawProperties() {
        return rawProperties;
    }

    @Basic
    @Column(name = "script")
    public String getScript() {
        return script;
    }

    @Transient
    public List<SettleTemplate> getTemplates() {
        return templates;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public void setFlowCode(String flowCode) {
        this.flowCode = flowCode;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public void setNeedStep(Boolean needStep) {
        this.needStep = needStep;
    }

    @Transient
    public SettleStep getSettleStep() {
        return settleStep;
    }

    public void setSettleStep(SettleStep settleStep) {
        this.settleStep = settleStep;
    }

    public void setRawProperties(String rawProperties) {
        this.rawProperties = rawProperties;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setTemplates(List<SettleTemplate> templates) {
        this.templates = templates;
    }

    @Transient
    public List<Long> getPackageIds() {
        return packageIds;
    }

    public void setPackageIds(List<Long> packageIds) {
        this.packageIds = packageIds;
    }

    @Transient
    public Map<String, Object> getProperties() {
        if (this.rawProperties != null) {
            try {
                Map<String, Object> properties = JsonUtils.fromJson(this.rawProperties, new TypeReference<Map<String, Object>>() {
                });
                return properties;
            } catch (Exception e) {
                logger.warn(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SettleFlow that = (SettleFlow) o;
        return Objects.equals(flowId, that.flowId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(flowId);
    }

    @Override
    public String toString() {
        return "SettleFlow {" +
                "flowId=" + flowId +
                ", flowName='" + flowName + '\'' +
                ", tenantId=" + tenantId +
                ", tenantCode='" + tenantCode + '\'' +
                ", rawProperties='" + rawProperties + '\'' +
                ", script='" + script + '\'' +
                '}';
    }

}
