package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "settle_template_attribute")
public class SettleTemplateAttribute implements Serializable {
    private Long attributeId;
    private Long templateId;
    private String attributeCode;
    private String attributeName;
    private Boolean enabled;
    private Boolean readonly;
    private Boolean required;
    private Boolean unique;
    private String expect;
    private String pattern;

    @Id
    @Column(name = "attribute_id")
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getAttributeId() {
        return attributeId;
    }

    @Basic
    @Column(name = "template_id")
    public Long getTemplateId() {
        return templateId;
    }

    @Basic
    @Column(name = "attribute_code")
    public String getAttributeCode() {
        return attributeCode;
    }

    @Basic
    @Column(name = "attribute_name")
    public String getAttributeName() {
        return attributeName;
    }

    @Basic
    @Column(name = "enabled")
    public Boolean getEnabled() {
        return enabled;
    }

    @Basic
    @Column(name = "readonly")
    public Boolean getReadonly() {
        return readonly;
    }

    @Basic
    @Column(name = "required")
    public Boolean getRequired() {
        return required;
    }

    @Basic
    @Column(name = "is_unique")
    public Boolean getUnique() {
        return unique;
    }

    @Basic
    @Column(name = "expect")
    public String getExpect() {
        return expect;
    }

    @Basic
    @Column(name = "pattern")
    public String getPattern() {
        return pattern;
    }

    public void setAttributeId(Long attributeId) {
        this.attributeId = attributeId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public void setAttributeCode(String attributeCode) {
        this.attributeCode = attributeCode;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setReadonly(Boolean readonly) {
        this.readonly = readonly;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    public void setExpect(String expect) {
        this.expect = expect;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SettleTemplateAttribute that = (SettleTemplateAttribute) o;
        return Objects.equals(this.attributeId, that.attributeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(attributeId);
    }
}
