package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.log.SystemLogDTO;
import com.xforceplus.jpa.listener.SystemLogListener;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @duanhy
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@EntityListeners({SystemLogListener.class})
@Entity
@Table(name = "sys_system_log")
public class SystemLog extends SystemLogDTO implements Serializable {



    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @ApiModelProperty("表名")
    @Basic
    @Column(name = "table_name")
    public String getTableName() {
        return tableName;
    }

    @ApiModelProperty("租户ID")
    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return tenantId;
    }

    @ApiModelProperty("操作主键ID")
    @Basic
    @Column(name = "identity_id")
    public Long getIdentityId() {
        return identityId;
    }

    @Basic
    @Column(name = "business_type")
    @ApiModelProperty("'操作业务类型：'")
    public String getBusinessType() {
        return businessType;
    }

    @Basic
    @Column(name = "action_code")
    @ApiModelProperty("' 操作类型:I U D")
    public String getActionCode() {
        return actionCode;
    }

    @Basic
    @Column(name = "content")
    @ApiModelProperty("操作内容：json格式相关数据")
    public String getContent() {
        return content;
    }

    @Basic
    @Column(name = "create_user_id")
    @ApiModelProperty("创建人ID")
    public String getCreateUserId() {
        return createUserId;
    }

    @Basic
    @Column(name = "create_user_name")
    @ApiModelProperty("创建人姓名")
    public String getCreateUserName() {
        return createUserName;
    }

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView({View.Info.class})
    @ApiModelProperty(value = "创建时间")
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Basic
    @Column(name = "login_id")
    @ApiModelProperty("请求ID")
    public String getLoginId() {
        return loginId;
    }

    @Basic
    @Column(name = "remark")
    @ApiModelProperty("备注")
    public String getRemark() {
        return remark;
    }


    @ApiModelProperty("批次id")
    @Basic
    @Column(name = "batchId")
    public String getBatchId() {
        return batchId;
    }

}
