package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.jpa.listener.TenantListener;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author geewit
 */
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({TenantListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_tenant")
public class Tenant extends TenantDto<TenantExtension> implements Serializable {
    @JsonIgnore
    private List<User> users;

    @JsonIgnore
    private List<OrgStruct> orgs;

    @Override
    @Id
    @Column(name = "tenant_id", nullable = false)
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    @NotBlank
    @Basic
    @Column(name = "tenant_name", nullable = false)
    public String getTenantName() {
        return tenantName;
    }

    @Override
    @NotBlank
    @Basic
    @Column(name = "tenant_code", nullable = false)
    public String getTenantCode() {
        return tenantCode;
    }

    @Override
    @Basic
    @Column(name = "tenant_desc")
    public String getTenantDesc() {
        return tenantDesc;
    }

    @Override
    @Basic
    @Column(name = "operate_reason")
    public String getOperateReason() {
        return operateReason;
    }

    @Override
    @Basic
    @Column(name = "settled_origin")
    public String getSettledOrigin() {
        return settledOrigin;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "tenant_logo")
    public String getTenantLogo() {
        return tenantLogo;
    }

    @Override
    @Basic
    @Column(name = "create_user_id", updatable = false)
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "tenant")
    public List<User> getUsers() {
        return users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "tenant")
    public List<OrgStruct> getOrgs() {
        return orgs;
    }

    public void setOrgs(List<OrgStruct> orgs) {
        this.orgs = orgs;
    }
}
