package com.xforceplus.jpa.listener;


import com.xforceplus.entity.Account;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 帐号自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class AccountListener extends OperatorListener<Account> {
    @PrePersist
    public void prePersist(Account entity) {
        if (entity.getEmail() != null || entity.getTelPhone() != null) {
            if (entity.getEmail() == null) {
                entity.setEmail(StringUtils.EMPTY);
            }
            if (entity.getTelPhone() == null) {
                entity.setTelPhone(StringUtils.EMPTY);
            }
        }
        if (entity.getBindAuthFlag() == null) {
            entity.setBindAuthFlag(false);
        }
        if (entity.getChangePasswordFlag() == null) {
            entity.setChangePasswordFlag(false);
        }
        if (entity.getDoubleAuthFlag() == null) {
            entity.setDoubleAuthFlag(false);
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(Account entity) {
        super.beforeUpdate(entity);
    }
}