package com.xforceplus.jpa.listener;


import com.xforceplus.entity.User;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Calendar;


/**
 * 帐号自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class UserListener extends OperatorListener<User> {
    @PrePersist
    public void prePersist(User entity) {
        if (entity.getUserPeriodTime() == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2030, Calendar.DECEMBER, 31);
            entity.setUserPeriodTime(calendar.getTime());
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (entity.getActiveStatus() == null) {
            entity.setActiveStatus(1);
        }
        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(User entity) {
        super.beforeUpdate(entity);
    }
}