package com.xforceplus.query;

import com.xforceplus.api.model.AccountModel.Request.Login;
import com.xforceplus.api.model.AccountModel.Request.Query;
import com.xforceplus.api.utils.Separator;
import com.xforceplus.entity.Account;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("all")
public class AccountQueryHelper {
    /**
     * 用户名{@value}
     */
    public static final String USER_NAME="username";
    /***
     * Email字段{@value}
     */
    public static final String EMAIL="email";
    /***
     * 电话
     */
    public static final String TEL_PHONE="telPhone";

    public static Specification<Account> querySpecification(Query query) {
        Specification<Account> specification = (Specification<Account>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (StringUtils.isNotBlank(query.getEmail())) {
                predicates.add(builder.equal(root.<String>get(EMAIL), query.getEmail()));
            }
            if (StringUtils.isNotBlank(query.getTelPhone())) {
                predicates.add(builder.equal(root.<String>get(TEL_PHONE), query.getTelPhone()));
            }
            if (StringUtils.isNotBlank(query.getUsername())) {
                if (StringUtils.contains(query.getUsername(),  Separator.AT)) {
                    predicates.add(builder.or(builder.equal(root.<String>get(USER_NAME), query.getUsername()), builder.equal(root.get(EMAIL), query.getUsername())));
                } else {
                    predicates.add(builder.or(builder.equal(root.<String>get(USER_NAME), query.getUsername()), builder.equal(root.get(TEL_PHONE), query.getUsername())));
                }
            }
            if (query.getAccountId() != null && query.getAccountId() > 0) {
                predicates.add(builder.equal(root.<Long>get("accountId"), query.getAccountId()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }


    public static Specification<Account> queryOneSpecification(String tenantCode, String username) {
        Specification<Account> specification = (Specification<Account>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (StringUtils.isNotBlank(username)) {
                String tenantUsername;
                if (tenantCode != null) {
                    tenantUsername = tenantCode + username;
                } else {
                    tenantUsername = username;
                }
                if (StringUtils.contains(username, Separator.AT)) {
                    predicates.add(builder.or(builder.equal(root.<String>get(USER_NAME), tenantUsername), builder.equal(root.<String>get(USER_NAME), username), builder.equal(root.get(EMAIL), username)));
                } else {
                    predicates.add(builder.or(builder.equal(root.<String>get(USER_NAME), tenantUsername), builder.equal(root.<String>get(USER_NAME), username), builder.equal(root.get(TEL_PHONE), username)));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<Account> queryOneSpecification(Login login) {
        Specification<Account> specification = (Specification<Account>) (root, criteriaQuery, builder) -> {
            Predicate predicate = builder.disjunction();
            if (StringUtils.isNotBlank(login.getUsername())) {
                if (StringUtils.contains(login.getUsername(),  Separator.AT)) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(USER_NAME), login.getUsername()), builder.equal(root.get(EMAIL), login.getUsername()));
                } else {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(USER_NAME), login.getUsername()), builder.equal(root.get(TEL_PHONE), login.getUsername()));
                }
            }
            if (StringUtils.isNotBlank(login.getEmail())) {
                predicate = builder.or(predicate, builder.equal(root.<String>get(USER_NAME), login.getEmail()), builder.equal(root.get(EMAIL), login.getEmail()));
            }
            if (StringUtils.isNotBlank(login.getTelPhone())) {
                predicate = builder.or(predicate, builder.equal(root.<String>get(USER_NAME), login.getTelPhone()), builder.equal(root.get(TEL_PHONE), login.getTelPhone()));
            }
            if (predicate == null) {
                throw new IllegalArgumentException("参数错误");
            } else {
                criteriaQuery.where(predicate);
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
