package com.xforceplus.query;

import com.xforceplus.api.model.CompanyApplyModel.Request.Query;
import com.xforceplus.entity.CompanyApply;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("all")
public class CompanyApplyQueryHelper {
    /***
     * 税号字段名 {@value}
     */
    public static final String TAX_NUM = "taxNum";
    /***
     * 公司名称字段 {@value}
     */
    public static final String COMPANY_NAME = "companyName";
    /***
     * 公司代码：{@value}
     */
    public static final String COMPANY_CODE = "companyCode";
    /***
     * 租户ID {@value}
     */
    public static final String TENANT_ID = "tenantId";

    /***
     * 公司ID :{@value}
     */
    public static final String COMPANY_ID = "companyId";
    /***
     * 状态 {@value}
     */
    public static final String STATUS = "status";

    public static Specification<CompanyApply> querySpecification(Query query) {
        Specification<CompanyApply> specification = (Specification<CompanyApply>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get(TENANT_ID), query.getTenantId()));
            }
            if (StringUtils.isNotBlank(query.getCompanyCode())) {
                predicates.add(builder.equal(root.<String>get(COMPANY_CODE), query.getCompanyCode()));
            }
            if (StringUtils.isNotBlank(query.getTaxNum())) {
                predicates.add(builder.equal(root.<String>get(TAX_NUM), query.getTaxNum()));
            }
            if (StringUtils.isNotBlank(query.getCompanyName())) {
                predicates.add(builder.like(root.get(COMPANY_NAME), query.getCompanyName() + "%"));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                predicates.add(builder.equal(root.<Long>get(COMPANY_ID), query.getCompanyId()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get(STATUS), query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<CompanyApply> queryOneSpecification(Query query) {
        Specification<CompanyApply> specification = (Specification<CompanyApply>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get(TENANT_ID), query.getTenantId()));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                predicates.add(builder.equal(root.<Long>get(COMPANY_ID), query.getCompanyId()));
            }
            if (StringUtils.isNotBlank(query.getCompanyCode()) || StringUtils.isNotBlank(query.getTaxNum()) || StringUtils.isNotBlank(query.getCompanyName())) {
                Predicate predicate = builder.disjunction();
                if (StringUtils.isNotBlank(query.getCompanyCode())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(COMPANY_CODE), query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank(query.getTaxNum())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(TAX_NUM), query.getTaxNum()));
                }
                if (StringUtils.isNotBlank(query.getCompanyName())) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get(COMPANY_NAME), query.getCompanyName()));
                }
                if (predicate != null) {
                    predicates.add(predicate);
                }
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get(STATUS), query.getStatus()));
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("查询参数不合法");
            } else {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
