package com.xforceplus.query;

import com.xforceplus.api.model.ResourcesetModel.Request.Query;
import com.xforceplus.entity.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("all")
public class ResourcesetQueryHelper {
    public static Specification<Resourceset> querySpecification(Query query) {
        Specification<Resourceset> specification = (Specification<Resourceset>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            boolean joinTable = false;
            if ((query.getTenantId() != null && query.getTenantId() > 0) || (query.getServicePackageId() != null && query.getServicePackageId() > 0) || StringUtils.isNotBlank(query.getServicePackageName())) {
                ListJoin<Resourceset, ServiceResourcesetRel> joinServiceResourcesetRels = root.joinList("serviceResourcesetRels", JoinType.LEFT);
                if (query.getServicePackageId() != null && query.getServicePackageId() > 0) {
                    predicates.add(builder.equal(joinServiceResourcesetRels.<Long>get("servicePackageId"), query.getServicePackageId()));
                } else if (query.getPackageIds() != null && !query.getPackageIds().isEmpty()) {
                    predicates.add(joinServiceResourcesetRels.<Long>get("servicePackageId").in(query.getPackageIds()));
                }
                if (query.getTenantId() != null && query.getTenantId() > 0) {
                    ListJoin<ServiceResourcesetRel, CompanyServiceRel> joinCompanyServiceRels = joinServiceResourcesetRels.join("servicePackage", JoinType.LEFT)
                            .joinList("companyServiceRels", JoinType.LEFT);
                    predicates.add(builder.equal(joinCompanyServiceRels.<Long>get("tenantId"), query.getTenantId()));
                }

                if (StringUtils.isNotBlank(query.getServicePackageName())) {
                    Join<ServiceResourcesetRel, ServicePackage> joinServicePackage = joinServiceResourcesetRels.join("servicePackage", JoinType.LEFT);
                    if (StringUtils.isNotBlank(query.getServicePackageName())) {
                        predicates.add(builder.like(joinServicePackage.get("servicePackageName"), query.getServicePackageName() + "%"));
                    }
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal(joinServicePackage.get("status"), 1));
                    }
                }
                joinTable = true;
            }
            if ((query.getRoleId() != null && query.getRoleId() > 0) || (query.getUserId() != null && query.getUserId() > 0)) {
                ListJoin<Resourceset, RoleResourcesetRel> joinRoleResourcesetRels = root.joinList("roleResourcesetRels", JoinType.LEFT);
                if (query.getRoleId() != null && query.getRoleId() > 0) {
                    predicates.add(builder.equal(joinRoleResourcesetRels.<Long>get("roleId"), query.getRoleId()));
                }
                if (query.getUserId() != null && query.getUserId() > 0) {
                    Join<RoleResourcesetRel, Role> joinRole = joinRoleResourcesetRels.join("role", JoinType.LEFT);
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal(joinRole.get("status"), 1));
                    }
                    ListJoin<Role, RoleUserRel> joinRoleUserRels = joinRole.joinList("roleUserRels", JoinType.LEFT);
                    predicates.add(builder.equal(joinRoleUserRels.<Long>get("userId"), query.getUserId()));
                }

                joinTable = true;
            }
            if ((query.getResourceId() != null && query.getResourceId() > 0) || (StringUtils.isNotBlank(query.getResourceCode())) || (StringUtils.isNotBlank(query.getResourceName()))) {
                ListJoin<Resourceset, ResourcesetResourceRel> joinResourcesetResourceRels = root.joinList("resourcesetResourceRels", JoinType.LEFT);
                if (query.getResourceId() != null && query.getResourceId() > 0) {
                    predicates.add(builder.equal(joinResourcesetResourceRels.<Long>get("resourceId"), query.getResourceId()));
                }
                if (StringUtils.isNotBlank(query.getResourceCode()) || (StringUtils.isNotBlank(query.getResourceName()))) {
                    Join<ResourcesetResourceRel, Resource> joinResource = joinResourcesetResourceRels.join("resource", JoinType.LEFT);
                    if (StringUtils.isNotBlank(query.getResourceCode())) {
                        predicates.add(builder.like(joinResource.get("resourceCode"), query.getResourceCode() + "%"));
                    }
                    if (StringUtils.isNotBlank(query.getResourceName())) {
                        predicates.add(builder.like(joinResource.get("resourceName"), query.getResourceName() + "%"));
                    }
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal(joinResource.get("status"), 1));
                    }
                }
                joinTable = true;
            }
            if (query.getResourcesetId() != null && query.getResourcesetId() > 0) {
                predicates.add(builder.equal(root.<Long>get("resourcesetId"), query.getResourcesetId()));
            }

            if (StringUtils.isNotBlank(query.getResourcesetName())) {
                predicates.add(builder.like(root.get("resourcesetName"), query.getResourcesetName() + "%"));
            }

            if (StringUtils.isNotBlank(query.getResourcesetNameEqual())) {
                predicates.add(builder.equal(root.get("resourcesetName"), query.getResourcesetName()));
            }

            if (StringUtils.isNotBlank(query.getResourcesetCode())) {
                predicates.add(builder.like(root.get("resourcesetCode"), query.getResourcesetCode() + "%"));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
            }
            if (query.getAppId() != null && query.getAppId() > 0) {
                predicates.add(builder.equal(root.<Long>get("appId"), query.getAppId()));
            }
            if (null != query.getContainCustomFlag() && !query.getContainCustomFlag()) {
                predicates.add(builder.isNull(root.get("roleId")));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                } else {
                    criteriaQuery.groupBy(root.<Long>get("resourcesetId"));
                    return criteriaQuery.getGroupRestriction();
                }
            } else {
                return criteriaQuery.getRestriction();
            }
        };
        return specification;
    }

    public static Specification<Resourceset> queryOneSpecification(Query query) {
        Specification<Resourceset> specification = (Specification<Resourceset>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getResourcesetId() != null && query.getResourcesetId() > 0) {
                predicates.add(builder.equal(root.<Long>get("resourcesetId"), query.getResourcesetId()));
            } else {
                if (StringUtils.isNotBlank(query.getResourcesetCode())) {
                    predicates.add(builder.equal(root.<String>get("resourcesetCode"), query.getResourcesetCode()));
                } else {
                    if (StringUtils.isNotBlank(query.getResourcesetName())) {
                        predicates.add(builder.equal(root.<String>get("resourcesetName"), query.getResourcesetName()));
                    }
                    if (query.getAppId() != null && query.getAppId() > 0) {
                        predicates.add(builder.equal(root.<Long>get("appId"), query.getAppId()));
                    }
                }
                if (null != query.getRoleId()) {
                    predicates.add(builder.equal(root.<String>get("roleId"), query.getRoleId()));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
