package com.xforceplus.query;

import com.xforceplus.api.model.RoleModel;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.RoleUserRel;
import com.xforceplus.entity.User;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author geewit
 */
@SuppressWarnings("all")
public class RoleQueryHelper {

    public static Specification<Role> querySpecification(RoleModel.Request.Query query) {
        Specification<Role> specification = (Specification<Role>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            boolean joinTable = false;
            if (query.getId() != null && query.getId() > 0) {
                predicates.add(builder.equal(root.<Long>get("id"), query.getId()));
            } else {
                if (query.getExcludeBoundCurrent() != null && query.getTenantId() != null && query.getTenantId() > 0 && query.getExcludeBoundCurrent() && query.getUserId() != null && query.getUserId() > 0) {
                    Subquery<RoleUserRel> subquery =  criteriaQuery.subquery(RoleUserRel.class);
                    Root roleUserRel = subquery.from(RoleUserRel.class);
                    subquery.select(roleUserRel);
                    Predicate[] subPredicates = new Predicate[] {
                            builder.equal(roleUserRel.<Long>get("userId"), query.getUserId()),
                            builder.equal(root.<Long>get("id"), roleUserRel.<Long>get("roleId"))
                    };
                    subquery.where(subPredicates);
                    predicates.add(builder.not(builder.exists(subquery)));
                } else if ((query.getUserId() != null && query.getUserId() > 0) || (query.getAccountId() != null && query.getAccountId() > 0)) {
                    ListJoin<Role, RoleUserRel> joinRoleUserRels = root.joinList("roleUserRels", JoinType.LEFT);
                    if (query.getUserId() != null && query.getUserId() > 0) {
                        predicates.add(builder.equal(joinRoleUserRels.<Long>get("userId"), query.getUserId()));
                    }
                    if (query.getAccountId() != null && query.getAccountId() > 0) {
                        Join<RoleUserRel, User> joinUser = joinRoleUserRels.join("user", JoinType.LEFT);
                        predicates.add(builder.equal(joinUser.<Long>get("accountId"), query.getAccountId()));
                    }
                    joinTable = true;
                }
                if (StringUtils.isNotBlank(query.getRoleCode())) {
                    if (query.getRoleCode().contains(";")) {
                        String[] codes = query.getRoleCode().split(";");
                        if (codes.length > 1) {
                            CriteriaBuilder.In<String> in = builder.in(root.get("code"));
                            Arrays.stream(codes).forEach(in::value);
                            predicates.add(in);
                        } else if (codes.length == 1) {
                            predicates.add(builder.equal(root.<String>get("code"), codes[0]));
                        }
                    } else {
                        predicates.add(builder.equal(root.<String>get("code"), query.getRoleCode()));
                    }
                }
                if (StringUtils.isNotBlank(query.getSearchKey())) {
                    predicates.add(builder.or(
                            builder.like(root.get("name"), query.getSearchKey() + "%"),
                            builder.equal(root.<String>get("code"), query.getSearchKey())
                    ));
                }
                if (StringUtils.isNotBlank(query.getRoleName())) {
                    predicates.add(builder.equal(root.<String>get("name"), query.getRoleName()));
                }
                if (query.getFromRoleId() != null && query.getFromRoleId() > 0) {
                    predicates.add(builder.equal(root.<Long>get("fromRoleId"), query.getFromRoleId()));
                }
                if (query.getStatus() != null) {
                    predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
                }
            }
            Boolean isSystem = query.getIsSystem();
            if (isSystem != null && isSystem) {
                predicates.add(builder.lessThanOrEqualTo(root.get("tenantId"), 0L));
            } else if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get("tenantId"), query.getTenantId()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                } else {
                    criteriaQuery.groupBy(root.<Long>get("id"));
                    return criteriaQuery.getGroupRestriction();
                }
            } else {
                return criteriaQuery.getRestriction();
            }
        };
        return specification;
    }

    public static Specification<Role> queryOneSpecification(RoleModel.Request.Query query) {
        Specification<Role> specification = (Specification<Role>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getId() != null && query.getId() > 0) {
                predicates.add(builder.equal(root.<Long>get("id"), query.getId()));
            } else {
                if (StringUtils.isNotBlank(query.getRoleCode())) {
                    predicates.add(builder.equal(root.<String>get("code"), query.getRoleCode()));
                }
                if (StringUtils.isNotBlank(query.getRoleName())) {
                    predicates.add(builder.equal(root.<String>get("name"), query.getRoleName()));
                }
            }
            Boolean isSystem = query.getIsSystem();
            if (isSystem != null && isSystem) {
                predicates.add(builder.lessThanOrEqualTo(root.get("tenantId"), 0L));
            } else if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get("tenantId"), query.getTenantId()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<RoleUserRel> queryRoleUserRelSpecification(Long tenantId, Long roleId, Long userId) {
        Specification<RoleUserRel> specification = (Specification<RoleUserRel>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (tenantId != null && tenantId > 0) {
                predicates.add(builder.equal(root.<Long>get("tenantId"), tenantId));
            }
            if (roleId != null && roleId > 0) {
                predicates.add(builder.equal(root.<Long>get("roleId"), roleId));
            }
            if (userId != null && userId > 0) {
                predicates.add(builder.equal(root.<Long>get("userId"), userId));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
