package com.xforceplus.query;

import com.xforceplus.api.model.SettleFlowPackageModel;
import com.xforceplus.entity.SettleFlow;
import com.xforceplus.entity.SettleFlowPackage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("all")
public class SettleFlowPackageQueryHelper {
    public static Specification<SettleFlowPackage> querySpecification(SettleFlowPackageModel.Request.Query query) {
        Specification<SettleFlowPackage> specification = (Specification<SettleFlowPackage>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getFlowId() != null && query.getFlowId() > 0) {
                predicates.add(builder.equal(root.<Long>get("flowId"), query.getFlowId()));
            } else {
                if (StringUtils.isNotBlank(query.getFlowCode())) {
                    Join<SettleFlowPackage, SettleFlow> joinFlow = root.join("flow", JoinType.LEFT);
                    predicates.add(builder.equal(joinFlow.<Long>get("flowCode"), query.getFlowCode()));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

}
