package com.xforceplus.query;

import com.xforceplus.api.model.SettleFlowModel;
import com.xforceplus.entity.SettleFlow;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("all")
public class SettleFlowQueryHelper {
    public static Specification<SettleFlow> querySpecification(SettleFlowModel.Request.Query query) {
        Specification<SettleFlow> specification = (Specification<SettleFlow>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getFlowId() != null && query.getFlowId() > 0) {
                predicates.add(builder.equal(root.<Long>get("flowId"), query.getFlowId()));
            }
            if (StringUtils.isNotBlank(query.getFlowCode())) {
                predicates.add(builder.equal(root.<String>get("flowCode"), query.getFlowCode()));
            }
            if (StringUtils.isNotBlank(query.getFlowName())) {
                predicates.add(builder.equal(root.<String>get("flowName"), query.getFlowName()));
            }
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get("tenantId"), query.getTenantId()));
            }
            if (StringUtils.isNotBlank(query.getTenantCode())) {
                predicates.add(builder.equal(root.<String>get("tenantCode"), query.getTenantCode()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

}
