package com.xforceplus.query;

import com.xforceplus.api.model.SettleServiceModel;
import com.xforceplus.entity.SettleService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("all")
public class SettleServiceQueryHelper {
    public static Specification<SettleService> querySpecification(SettleServiceModel.Request.Query query) {
        Specification<SettleService> specification = (Specification<SettleService>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getServiceId() != null && query.getServiceId() > 0) {
                predicates.add(builder.equal(root.<Long>get("serviceId"), query.getServiceId()));
            }
            if (StringUtils.isNotBlank(query.getServiceCode())) {
                predicates.add(builder.equal(root.<String>get("serviceCode"), query.getServiceCode()));
            }
            if (StringUtils.isNotBlank(query.getServiceName())) {
                predicates.add(builder.equal(root.<String>get("serviceName"), query.getServiceName()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

}
