/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.entity.User;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface UserDao
extends JpaRepository<User, Long>,
JpaSpecificationExecutor<User> {
    @Modifying(clearAutomatically=true)
    @Query(value="delete from User u where u.id = :userId")
    public void deleteById(@Param(value="userId") Long var1);

    @EntityGraph(value="User.graph", type=EntityGraph.EntityGraphType.FETCH)
    public Optional<User> findById(Long var1);

    public Optional<User> findByTenantIdAndUserCode(long var1, String var3);

    @Query(value="select u from User u where u.tenantId = :tenantId and u.userCode = :userCode")
    public List<User> findAllByTenantIdAndUserCode(@Param(value="tenantId") long var1, @Param(value="userCode") String var3);

    @EntityGraph(value="User.graph", type=EntityGraph.EntityGraphType.FETCH)
    public List<User> findByAccountId(Long var1);

    public User findFirstByTenantIdAndAccountId(Long var1, Long var2);

    @Query(value="select u.id from User u where u.tenantId = :tenantId and u.userCode = :userCode")
    public Long findIdByTenantIdAndCode(@Param(value="tenantId") long var1, @Param(value="userCode") String var3);

    @Query(value="select u.id from User u where u.tenantId = :tenantId and u.userCode = :userCode")
    public List<Long> findListByTenantIdAndUserCode(@Param(value="tenantId") Long var1, @Param(value="userCode") String var2);

    @EntityGraph(value="User.graph", type=EntityGraph.EntityGraphType.FETCH)
    @Query(value="select u from User u where u.tenantId = :tenantId and u.id = :userId")
    public Optional<User> findByTenantIdAndUserId(@Param(value="tenantId") long var1, @Param(value="userId") long var3);

    public List<User> findByTenantId(Long var1);

    @Modifying(flushAutomatically=true)
    @Query(value="update User u set u.tenantId = :tenantId where u.id in (:userIds)")
    public void batchUpdateTenant(@Param(value="userIds") List<Long> var1, @Param(value="tenantId") Long var2);

    public List<User> findByAccountIdIn(Collection<Long> var1);
}

