/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao.impl;

import com.xforceplus.api.model.RoleModel;
import com.xforceplus.dao.CustomizedRoleDao;
import com.xforceplus.domain.tenant.RoleExportDto;
import com.xforceplus.domain.tenant.RoleRelAccountExportDto;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public class CustomizedRoleDaoImpl
implements CustomizedRoleDao {
    private static final Logger logger = LoggerFactory.getLogger(CustomizedRoleDaoImpl.class);
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<RoleExportDto> findRolesResourcesetRel(Long tenantId, RoleModel.Request.Export query, Pageable pageable) {
        StringBuilder selectBuilder = new StringBuilder("SELECT DISTINCT a.role_id as roleId,IF(a.role_name IS NULL,'',a.role_name)  as roleName,IF(a.role_code IS NULL,'',a.role_code)  as roleCode,c.resourceset_id as resourcesetId,IF(c.resourceset_name IS NULL,'',c.resourceset_name)  as resourcesetName,IF(c.resourceset_code IS NULL,'',c.resourceset_code)  as resourcesetCode,e.resource_id as resourceId,IF(e.resource_name IS NULL,'',e.resource_name)  as resourceName,IF(e.resource_code IS NULL,'',e.resource_code)  as resourceCode,g.service_package_id as servicePackageId,IF(g.service_package_name IS NULL,'',g.service_package_name)  as servicePackageName,IF(g.service_package_code IS NULL,'',g.service_package_code)  as servicePackageCode FROM sys_role a LEFT JOIN sys_role_resourceset_rel b ON a.role_id = b.role_id LEFT JOIN sys_resourceset c ON c.resourceset_id = b.resouseset_id LEFT JOIN sys_resourceset_resource_rel d ON c.resourceset_id = d.resourceset_id LEFT JOIN sys_resource e ON e.resource_id = d.resource_id LEFT JOIN bss_service_resourceset_rel f ON c.resourceset_id = f.resourceset_id LEFT JOIN bss_service_package g ON g.service_package_id = f.service_package_id LEFT JOIN bss_company_service_rel h ON h.service_package_id = f.service_package_id WHERE 1=1");
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" and h.tenant_id = :tenantId").append(" and a.tenant_id = :tenantId");
        if (query != null) {
            if (!CollectionUtils.isEmpty((Collection)query.getIds())) {
                queryBuilder.append(" and a.role_id in (:ids)");
            } else {
                if (StringUtils.isNotBlank((CharSequence)query.getRoleCode())) {
                    queryBuilder.append(" and a.role_code = :roleCode");
                } else if (StringUtils.isNotBlank((CharSequence)query.getSearchKey())) {
                    queryBuilder.append(" and a.role_code like :searchKey");
                }
                if (StringUtils.isNotBlank((CharSequence)query.getRoleName())) {
                    queryBuilder.append(" and a.role_name = :roleName");
                } else if (StringUtils.isNotBlank((CharSequence)query.getSearchKey())) {
                    queryBuilder.append(" and a.role_name like :searchKey");
                }
                if (null != query.getStatus()) {
                    queryBuilder.append(" and a.status = :status");
                }
            }
        }
        selectBuilder.append((CharSequence)queryBuilder);
        String selectHql = selectBuilder.toString();
        logger.info("selectHQL = {}", (Object)selectHql);
        Query selectQuery = this.entityManager.createNativeQuery(selectHql);
        selectQuery.setParameter("tenantId", (Object)tenantId);
        if (query != null) {
            if (!CollectionUtils.isEmpty((Collection)query.getIds())) {
                selectQuery.setParameter("ids", (Object)query.getIds());
            } else {
                if (StringUtils.isNotBlank((CharSequence)query.getRoleName()) || StringUtils.isNotBlank((CharSequence)query.getRoleCode())) {
                    if (StringUtils.isNotBlank((CharSequence)query.getRoleName())) {
                        selectQuery.setParameter("roleName", (Object)query.getRoleName());
                    }
                    if (StringUtils.isNotBlank((CharSequence)query.getRoleCode())) {
                        selectQuery.setParameter("roleCode", (Object)query.getRoleCode());
                    }
                } else if (StringUtils.isNotBlank((CharSequence)query.getSearchKey())) {
                    selectQuery.setParameter("searchKey", (Object)(query.getSearchKey() + "%"));
                }
                if (null != query.getStatus()) {
                    selectQuery.setParameter("status", (Object)query.getStatus());
                }
            }
        }
        ((NativeQuery)selectQuery.unwrap(NativeQuery.class)).addScalar("roleId", (Type)StandardBasicTypes.LONG).addScalar("roleName", (Type)StandardBasicTypes.STRING).addScalar("roleCode", (Type)StandardBasicTypes.STRING).addScalar("resourceId", (Type)StandardBasicTypes.LONG).addScalar("resourceName", (Type)StandardBasicTypes.STRING).addScalar("resourceCode", (Type)StandardBasicTypes.STRING).addScalar("resourcesetId", (Type)StandardBasicTypes.LONG).addScalar("resourcesetName", (Type)StandardBasicTypes.STRING).addScalar("resourcesetCode", (Type)StandardBasicTypes.STRING).addScalar("servicePackageId", (Type)StandardBasicTypes.LONG).addScalar("servicePackageName", (Type)StandardBasicTypes.STRING).addScalar("servicePackageCode", (Type)StandardBasicTypes.STRING).setResultTransformer(Transformers.aliasToBean(RoleExportDto.class));
        return selectQuery.getResultList();
    }

    @Override
    public List<RoleRelAccountExportDto> findRolesRelAccount(Long tenantId, RoleModel.Request.Export query, Pageable pageable) {
        StringBuilder selectBuilder = new StringBuilder("SELECT a.role_id as roleId,IF(a.role_name IS NULL,'',a.role_name) as roleName,IF(a.role_code IS NULL,'',a.role_code) as roleCode,IF(d.email IS NULL,'',d.email) as email,IF(d.tel_phone IS NULL,'',d.tel_phone) as telPhone,IF(d.username IS NULL,'',d.username) as username,IF(c.user_name IS NULL,'',c.user_name) as realName FROM sys_role a LEFT JOIN sys_role_user_rel b ON a.role_id = b.role_id LEFT JOIN sys_user c ON c.user_id = b.user_id LEFT JOIN sys_sass_account d ON c.account_id = d.account_id WHERE 1=1");
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(" and a.tenant_id = :tenantId").append(" and c.tenant_id = :tenantId");
        if (query != null) {
            if (!CollectionUtils.isEmpty((Collection)query.getIds())) {
                queryBuilder.append(" and a.role_id in (:ids)");
            } else {
                if (StringUtils.isNotBlank((CharSequence)query.getRoleCode())) {
                    queryBuilder.append(" and a.role_code = :roleCode");
                } else if (StringUtils.isNotBlank((CharSequence)query.getSearchKey())) {
                    queryBuilder.append(" and a.role_code like :searchKey");
                }
                if (StringUtils.isNotBlank((CharSequence)query.getRoleName())) {
                    queryBuilder.append(" and a.role_name = :roleName");
                } else if (StringUtils.isNotBlank((CharSequence)query.getSearchKey())) {
                    queryBuilder.append(" and a.role_name like :searchKey");
                }
                if (null != query.getStatus()) {
                    queryBuilder.append(" and a.status = :status");
                }
            }
        }
        selectBuilder.append((CharSequence)queryBuilder);
        String selectHql = selectBuilder.toString();
        logger.info("selectHQL = {}", (Object)selectHql);
        Query selectQuery = this.entityManager.createNativeQuery(selectHql);
        selectQuery.setParameter("tenantId", (Object)tenantId);
        if (query != null) {
            if (!CollectionUtils.isEmpty((Collection)query.getIds())) {
                selectQuery.setParameter("ids", (Object)query.getIds());
            } else {
                if (StringUtils.isNotBlank((CharSequence)query.getRoleName()) || StringUtils.isNotBlank((CharSequence)query.getRoleCode())) {
                    if (StringUtils.isNotBlank((CharSequence)query.getRoleName())) {
                        selectQuery.setParameter("roleName", (Object)query.getRoleName());
                    }
                    if (StringUtils.isNotBlank((CharSequence)query.getRoleCode())) {
                        selectQuery.setParameter("roleCode", (Object)query.getRoleCode());
                    }
                } else if (StringUtils.isNotBlank((CharSequence)query.getSearchKey())) {
                    selectQuery.setParameter("searchKey", (Object)(query.getSearchKey() + "%"));
                }
                if (null != query.getStatus()) {
                    selectQuery.setParameter("status", (Object)query.getStatus());
                }
            }
        }
        ((NativeQuery)selectQuery.unwrap(NativeQuery.class)).addScalar("roleId", (Type)StandardBasicTypes.LONG).addScalar("roleName", (Type)StandardBasicTypes.STRING).addScalar("roleCode", (Type)StandardBasicTypes.STRING).addScalar("email", (Type)StandardBasicTypes.STRING).addScalar("telPhone", (Type)StandardBasicTypes.STRING).addScalar("username", (Type)StandardBasicTypes.STRING).addScalar("realName", (Type)StandardBasicTypes.STRING).setResultTransformer(Transformers.aliasToBean(RoleRelAccountExportDto.class));
        return selectQuery.getResultList();
    }
}

