/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.entity.CompanyExtension;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import com.xforceplus.jpa.listener.CompanyListener;
import io.geewit.core.jackson.view.View;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.envers.Audited;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@EntityListeners(value={CompanyListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name="bss_company")
public class Company
extends CompanyDto<Tenant, CompanyExtension>
implements Serializable {
    @JsonIgnore
    private List<OrgStruct> orgs;
    @JsonView(value={View.Info.class})
    private List<String> companyNos;
    @JsonView(value={View.Info.class})
    private OrgStruct parentOrg;

    @Id
    @Column(name="company_id", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="SnowflakeGenerator")
    @GenericGenerator(name="SnowflakeGenerator", strategy="io.geewit.data.jpa.essential.id.SnowflakeGenerator")
    public Long getCompanyId() {
        return this.companyId;
    }

    @NotNull
    @Basic
    @Column(name="company_code", nullable=false)
    public String getCompanyCode() {
        return this.companyCode;
    }

    @NotNull
    @Audited
    @Basic
    @Column(name="company_name", nullable=false)
    public String getCompanyName() {
        return this.companyName;
    }

    @NotNull
    @Audited
    @Basic
    @Column(name="tax_num")
    public String getTaxNum() {
        return this.taxNum;
    }

    @Basic
    @Column(name="location_area")
    public String getLocationArea() {
        return this.locationArea;
    }

    @Basic
    @Column(name="location_city")
    public String getLocationCity() {
        return this.locationCity;
    }

    @Basic
    @Column(name="location_addr")
    public String getLocationAddr() {
        return this.locationAddr;
    }

    @Basic
    @Column(name="company_phone")
    public String getCompanyPhone() {
        return this.companyPhone;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="business_start_time")
    public Date getBusinessStartTime() {
        return this.businessStartTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="business_end_time")
    public Date getBusinessEndTime() {
        return this.businessEndTime;
    }

    @Basic
    @Column(name="business_time_long")
    public Integer getBusinessTimeLong() {
        return this.businessTimeLong;
    }

    @Basic
    @Column(name="business_scope")
    public String getBusinessScope() {
        return this.businessScope;
    }

    @Basic
    @Column(name="company_logo")
    public String getCompanyLogo() {
        return this.companyLogo;
    }

    @Basic
    @Column(name="business_license")
    public String getBusinessLicense() {
        return this.businessLicense;
    }

    @Basic
    @Column(name="plat_manager_status")
    public Integer getPlatManagerStatus() {
        return this.platManagerStatus;
    }

    @Basic
    @Column(name="manager_location")
    public String getManagerLocation() {
        return this.managerLocation;
    }

    @Basic
    @Column(name="manager_name")
    public String getManagerName() {
        return this.managerName;
    }

    @Basic
    @Column(name="manager_card_type")
    public String getManagerCardType() {
        return this.managerCardType;
    }

    @Basic
    @Column(name="manager_id_card")
    public String getManagerIdCard() {
        return this.managerIdCard;
    }

    @Basic
    @Column(name="manager_phone")
    public String getManagerPhone() {
        return this.managerPhone;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="manager_id_card_start_time")
    public Date getManagerIdCardStartTime() {
        return this.managerIdCardStartTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="manager_id_card_end_time")
    public Date getManagerIdCardEndTime() {
        return this.managerIdCardEndTime;
    }

    @Basic
    @Column(name="manager_id_card_time_long")
    public Integer getManagerIdCardTimeLong() {
        return this.managerIdCardTimeLong;
    }

    @Basic
    @Column(name="manager_id_card_front_photo")
    public String getManagerIdCardFrontPhoto() {
        return this.managerIdCardFrontPhoto;
    }

    @Basic
    @Column(name="manager_id_card_back_photo")
    public String getManagerIdCardBackPhoto() {
        return this.managerIdCardBackPhoto;
    }

    @Basic
    @Column(name="bank_name")
    public String getBankName() {
        return this.bankName;
    }

    @Basic
    @Column(name="bank_branch_name")
    public String getBankBranchName() {
        return this.bankBranchName;
    }

    @Basic
    @Column(name="bank_no")
    public String getBankNo() {
        return this.bankNo;
    }

    @Basic
    @Column(name="bank_area")
    public String getBankArea() {
        return this.bankArea;
    }

    @Basic
    @Column(name="bank_city")
    public String getBankCity() {
        return this.bankCity;
    }

    @Basic
    @Column(name="operate_reason")
    public String getOperateReason() {
        return this.operateReason;
    }

    @Basic
    @Column(name="tradition_authen_flag")
    public Integer getTraditionAuthenFlag() {
        return this.traditionAuthenFlag;
    }

    @Basic
    @Column(name="inspection_service_flag")
    public Integer getInspectionServiceFlag() {
        return this.inspectionServiceFlag;
    }

    @Basic
    @Column(name="speed_inspection_channel_flag")
    public Integer getSpeedInspectionChannelFlag() {
        return this.speedInspectionChannelFlag;
    }

    @Basic
    @Column(name="status")
    public Integer getStatus() {
        return this.status;
    }

    @Basic
    @Column(name="cquota", precision=2)
    public BigDecimal getCquota() {
        return this.cquota;
    }

    @Basic
    @Column(name="squota", precision=2)
    public BigDecimal getSquota() {
        return this.squota;
    }

    @Basic
    @Column(name="ce_quota", precision=2)
    public BigDecimal getCeQuota() {
        return this.ceQuota;
    }

    @Basic
    @Column(name="ju_quota", precision=2)
    public BigDecimal getJuQuota() {
        return this.juQuota;
    }

    @Basic
    @Column(name="se_quota", precision=2)
    public BigDecimal getSeQuota() {
        return this.seQuota;
    }

    @Basic
    @Column(name="regist_location_area")
    public String getRegistLocationArea() {
        return this.registLocationArea;
    }

    @Basic
    @Column(name="regist_location_city")
    public String getRegistLocationCity() {
        return this.registLocationCity;
    }

    @Basic
    @Column(name="regist_location_addr")
    public String getRegistLocationAddr() {
        return this.registLocationAddr;
    }

    @Basic
    @Column(name="taxpayer_qualification_type")
    public Integer getTaxpayerQualificationType() {
        return this.taxpayerQualificationType;
    }

    @Basic
    @Column(name="taxpayer_qualification")
    public String getTaxpayerQualification() {
        return this.taxpayerQualification;
    }

    @Basic
    @Column(name="proxy_manager_name")
    public String getProxyManagerName() {
        return this.proxyManagerName;
    }

    @Basic
    @Column(name="proxy_manager_card_type")
    public String getProxyManagerCardType() {
        return this.proxyManagerCardType;
    }

    @Basic
    @Column(name="proxy_manager_id_card")
    public String getProxyManagerIdCard() {
        return this.proxyManagerIdCard;
    }

    @Basic
    @Column(name="proxy_manager_phone")
    public String getProxyManagerPhone() {
        return this.proxyManagerPhone;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="proxy_manager_id_card_start_time")
    public Date getProxyManagerIdCardStartTime() {
        return this.proxyManagerIdCardStartTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="proxy_manager_id_card_end_time")
    public Date getProxyManagerIdCardEndTime() {
        return this.proxyManagerIdCardEndTime;
    }

    @Basic
    @Column(name="proxy_manager_id_card_time_long")
    public Integer getProxyManagerIdCardTimeLong() {
        return this.proxyManagerIdCardTimeLong;
    }

    @Basic
    @Column(name="proxy_manager_id_card_front_photo")
    public String getProxyManagerIdCardFrontPhoto() {
        return this.proxyManagerIdCardFrontPhoto;
    }

    @Basic
    @Column(name="proxy_manager_id_card_back_photo")
    public String getProxyManagerIdCardBackPhoto() {
        return this.proxyManagerIdCardBackPhoto;
    }

    @Basic
    @Column(name="create_user_id", updatable=false)
    public String getCreaterId() {
        return this.createrId;
    }

    @Basic
    @Column(name="create_user_name", updatable=false)
    public String getCreaterName() {
        return this.createrName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="create_time", updatable=false)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Basic
    @Column(name="update_user_id")
    public String getUpdaterId() {
        return this.updaterId;
    }

    @Basic
    @Column(name="update_user_name")
    public String getUpdaterName() {
        return this.updaterName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="update_time")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Audited
    @Temporal(value=TemporalType.DATE)
    @Column(name="effective_date")
    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    @Audited
    @Basic
    @Column(name="is_effective")
    public Boolean getEffective() {
        return this.effective;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="company")
    public List<OrgStruct> getOrgs() {
        return this.orgs;
    }

    public void setOrgs(List<OrgStruct> orgs) {
        this.orgs = orgs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Company company = (Company)o;
        return Objects.equals(this.companyId, company.companyId);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.companyId);
    }

    @Transient
    public List<String> getCompanyNos() {
        return this.companyNos;
    }

    public void setCompanyNos(List<String> companyNos) {
        this.companyNos = companyNos;
    }

    @Transient
    public OrgStruct getParentOrg() {
        return this.parentOrg;
    }

    public void setParentOrg(OrgStruct parentOrg) {
        this.parentOrg = parentOrg;
    }
}

