/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.entity.App;
import com.xforceplus.entity.ResourceApiRel;
import com.xforceplus.entity.ResourcesetResourceRel;
import com.xforceplus.jpa.listener.ResourceListener;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@NamedEntityGraphs(value={@NamedEntityGraph(name="Resource.graph", attributeNodes={@NamedAttributeNode(value="app")})})
@DynamicInsert
@DynamicUpdate
@EntityListeners(value={ResourceListener.class})
@Entity
@Table(name="sys_resource")
public class Resource
extends ResourceDto<Resource>
implements Serializable {
    @JsonIgnore
    private App app;
    @JsonIgnore
    private List<ResourcesetResourceRel> resourcesetResourceRels;
    @JsonIgnore
    private List<ResourceApiRel> resourceApiRels;

    @Id
    @Column(name="resource_id", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="SnowflakeGenerator")
    @GenericGenerator(name="SnowflakeGenerator", strategy="io.geewit.data.jpa.essential.id.SnowflakeGenerator")
    public Long getResourceId() {
        return this.resourceId;
    }

    @Basic
    @Column(name="app_id")
    public Long getAppId() {
        return this.appId != null && this.appId > 0L ? this.appId : null;
    }

    @Basic
    @Column(name="resource_code", nullable=false)
    public String getResourceCode() {
        return this.resourceCode;
    }

    @Basic
    @Column(name="resource_name", nullable=false)
    public String getResourceName() {
        return this.resourceName;
    }

    @Basic
    @Column(name="resource_platform")
    public Integer getResourcePlatform() {
        return this.resourcePlatform;
    }

    @Basic
    @Column(name="resource_type")
    public Integer getResourceType() {
        return this.resourceType;
    }

    @Basic
    @Column(name="create_user_id", updatable=false)
    public String getCreaterId() {
        return this.createrId;
    }

    @Basic
    @Column(name="create_user_name", updatable=false)
    public String getCreaterName() {
        return this.createrName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="create_time", updatable=false)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Basic
    @Column(name="update_user_id")
    public String getUpdaterId() {
        return this.updaterId;
    }

    @Basic
    @Column(name="update_user_name")
    public String getUpdaterName() {
        return this.updaterName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="update_time")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Basic
    @Column(name="parent_id")
    public Long getParentId() {
        return this.parentId;
    }

    @Basic
    @Column(name="status", nullable=false)
    public Integer getStatus() {
        return this.status;
    }

    @Basic
    @Column(name="is_service_package")
    public Boolean getIsServicePackage() {
        return this.isServicePackage;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="app_id", referencedColumnName="app_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    @NotFound(action=NotFoundAction.IGNORE)
    public App getApp() {
        return this.app;
    }

    public void setApp(App app) {
        this.app = app;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="resource")
    public List<ResourcesetResourceRel> getResourcesetResourceRels() {
        return this.resourcesetResourceRels;
    }

    public void setResourcesetResourceRels(List<ResourcesetResourceRel> resourcesetResourceRels) {
        this.resourcesetResourceRels = resourcesetResourceRels;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="resource")
    public List<ResourceApiRel> getResourceApiRels() {
        return this.resourceApiRels;
    }

    public void setResourceApiRels(List<ResourceApiRel> resourceApiRels) {
        this.resourceApiRels = resourceApiRels;
    }

    @Transient
    public String getAppName() {
        if (this.appName != null) {
            return this.appName;
        }
        if (this.app != null) {
            this.appName = this.app.getAppName();
            return this.appName;
        }
        return null;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

