/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.AccountModel;
import com.xforceplus.entity.Account;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class AccountQueryHelper {
    public static final String USER_NAME = "username";
    public static final String EMAIL = "email";
    public static final String TEL_PHONE = "telPhone";

    public static Specification<Account> querySpecification(AccountModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)query.getEmail())) {
                predicates.add(builder.equal((Expression)root.get(EMAIL), (Object)query.getEmail()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTelPhone())) {
                predicates.add(builder.equal((Expression)root.get(TEL_PHONE), (Object)query.getTelPhone()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getUsername())) {
                if (StringUtils.contains((CharSequence)query.getUsername(), (CharSequence)"@")) {
                    predicates.add(builder.or((Expression)builder.equal((Expression)root.get(USER_NAME), (Object)query.getUsername()), (Expression)builder.equal((Expression)root.get(EMAIL), (Object)query.getUsername())));
                } else {
                    predicates.add(builder.or((Expression)builder.equal((Expression)root.get(USER_NAME), (Object)query.getUsername()), (Expression)builder.equal((Expression)root.get(TEL_PHONE), (Object)query.getUsername())));
                }
            }
            if (query.getAccountId() != null && query.getAccountId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("accountId"), (Object)query.getAccountId()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<Account> queryOneSpecification(String tenantCode, String username) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)username)) {
                String tenantUsername = tenantCode != null ? tenantCode + username : username;
                if (StringUtils.contains((CharSequence)username, (CharSequence)"@")) {
                    predicates.add(builder.or(new Predicate[]{builder.equal((Expression)root.get(USER_NAME), (Object)tenantUsername), builder.equal((Expression)root.get(USER_NAME), (Object)username), builder.equal((Expression)root.get(EMAIL), (Object)username)}));
                } else {
                    predicates.add(builder.or(new Predicate[]{builder.equal((Expression)root.get(USER_NAME), (Object)tenantUsername), builder.equal((Expression)root.get(USER_NAME), (Object)username), builder.equal((Expression)root.get(TEL_PHONE), (Object)username)}));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<Account> queryOneSpecification(AccountModel.Request.Login login) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            Predicate predicate = builder.disjunction();
            if (StringUtils.isNotBlank((CharSequence)login.getUsername())) {
                predicate = StringUtils.contains((CharSequence)login.getUsername(), (CharSequence)"@") ? builder.or(new Predicate[]{predicate, builder.equal((Expression)root.get(USER_NAME), (Object)login.getUsername()), builder.equal((Expression)root.get(EMAIL), (Object)login.getUsername())}) : builder.or(new Predicate[]{predicate, builder.equal((Expression)root.get(USER_NAME), (Object)login.getUsername()), builder.equal((Expression)root.get(TEL_PHONE), (Object)login.getUsername())});
            }
            if (StringUtils.isNotBlank((CharSequence)login.getEmail())) {
                predicate = builder.or(new Predicate[]{predicate, builder.equal((Expression)root.get(USER_NAME), (Object)login.getEmail()), builder.equal((Expression)root.get(EMAIL), (Object)login.getEmail())});
            }
            if (StringUtils.isNotBlank((CharSequence)login.getTelPhone())) {
                predicate = builder.or(new Predicate[]{predicate, builder.equal((Expression)root.get(USER_NAME), (Object)login.getTelPhone()), builder.equal((Expression)root.get(TEL_PHONE), (Object)login.getTelPhone())});
            }
            if (predicate == null) {
                throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
            }
            criteriaQuery.where((Expression)predicate);
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

