/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.dao.CustomizedCompanyDao;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.ServicePackage;
import io.geewit.data.jpa.envers.repository.EnversRevisionRepository;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface CompanyDao
extends JpaRepository<Company, Long>,
JpaSpecificationExecutor<Company>,
CustomizedCompanyDao,
EnversRevisionRepository<Company, Long, String> {
    @Modifying(clearAutomatically=true)
    @Query(value="delete from Company c where c.companyId = :companyId")
    public void deleteById(@Param(value="companyId") Long var1);

    public List<Company> findAll();

    @Query(value="select new com.xforceplus.entity.ServicePackage(sp.servicePackageId, sp.servicePackageName, sp.appId) from com.xforceplus.entity.CompanyServiceRel csr left join com.xforceplus.entity.ServicePackage sp on sp.servicePackageId = csr.servicePackageId where csr.companyId = :companyId")
    public List<ServicePackage> findPackagesByCompanyId(@Param(value="companyId") long var1);

    @Query(value="select count(c.companyId) from Company c where (c.companyCode = :companyCode or c.taxNum = :taxNum ) and c.companyId <> :companyId ")
    public long validateExistCompany(@Param(value="companyId") long var1, @Param(value="companyCode") String var3, @Param(value="taxNum") String var4);

    public List<Company> findByTaxNum(@Param(value="taxNum") String var1);

    @Query(value="select count(c.companyId) from Company c where (c.companyCode = :companyCode or c.taxNum = :taxNum ) ")
    public long validateExistCompany(@Param(value="companyCode") String var1, @Param(value="taxNum") String var2);

    @Modifying(flushAutomatically=true)
    @Query(value="update Company c set c.status = :status where c.companyId = :companyId")
    public int updateStatus(@Param(value="companyId") long var1, @Param(value="status") int var3);

    @Query(value="select o.tenant_id, o.company_id from sys_org_struct o LEFT JOIN (select rel.tenant_id, rel.company_id from bss_tenant_company_rel rel) as r ON o.tenant_id = r.tenant_id and o.company_id = r.company_id where r.tenant_id is null and r.company_id is null and o.tenant_id > 0 and o.company_id > 0  group by o.tenant_id, o.company_id", nativeQuery=true)
    public List<Map<String, Object>> findFixingCompanies();

    @Query(value="select count(ca.revision) from bss_company_audit ca where ca.company_name = :companyName and ca.tax_num = :taxNum and ca.is_effective = 1", nativeQuery=true)
    public long countAuditByTaxNumAndCompanyName(@Param(value="taxNum") String var1, @Param(value="companyName") String var2);

    @Query(value="select count(ca.revision) from bss_company_audit ca where ca.company_name = :companyName and ca.tax_num = :taxNum and ca.effective_date <= :effectiveDate and ca.is_effective = 1", nativeQuery=true)
    public long countAuditByTaxNumAndCompanyNameAndEffectiveDate(@Param(value="taxNum") String var1, @Param(value="companyName") String var2, @Param(value="effectiveDate") Date var3);

    @Modifying(flushAutomatically=true)
    @Query(value="update bss_company_audit ca set ca.is_effective = :effective where ca.company_id = :companyId and ca.revision = :revision", nativeQuery=true)
    public int updateAuditEffective(@Param(value="companyId") long var1, @Param(value="revision") long var3, @Param(value="effective") boolean var5);
}

