/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.entity.ServicePackage;
import java.util.List;
import org.apache.commons.lang3.tuple.MutablePair;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface CompanyServiceRelDao
extends JpaRepository<CompanyServiceRel, Long>,
JpaSpecificationExecutor<CompanyServiceRel> {
    @Modifying(clearAutomatically=true)
    @Query(value="delete from CompanyServiceRel rel where rel.id = :id")
    public void deleteById(@Param(value="id") Long var1);

    @Query(value="select csr.servicePackage from CompanyServiceRel csr where csr.companyId = :companyId and csr.status = 1 and csr.servicePackage.status = 1")
    public List<ServicePackage> findByCompanyId(@Param(value="companyId") Long var1);

    @Query(value="select csr.servicePackage from CompanyServiceRel csr where csr.tenantId = :tenantId and csr.status = 1 and csr.servicePackage.status = 1")
    public List<ServicePackage> findByTenantId(@Param(value="tenantId") Long var1);

    @Query(value="select new org.apache.commons.lang3.tuple.MutablePair(csr.companyId, csr.servicePackage) from CompanyServiceRel csr where csr.tenantId = :tenantId and csr.status = 1 and csr.servicePackage.status = 1")
    public List<MutablePair<Long, ServicePackage>> findPairsByTenantId(@Param(value="tenantId") Long var1);

    public List<CompanyServiceRel> findCompanyServiceRelByTenantIdEqualsAndCompanyIdEquals(Long var1, Long var2);

    @Modifying(flushAutomatically=true)
    @Query(value="update CompanyServiceRel rel set rel.status = :status, rel.operateReason = :reason where rel.tenantId = :tenantId and rel.companyId = :companyId")
    public void updateStatus(@Param(value="tenantId") long var1, @Param(value="companyId") long var3, @Param(value="status") int var5, @Param(value="reason") String var6);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from CompanyServiceRel rel where rel.servicePackageId = :servicePackageId")
    public void deleteByPackageId(@Param(value="servicePackageId") long var1);

    public long countByServicePackageId(long var1);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from CompanyServiceRel rel where rel.servicePackageId = :servicePackageId and rel.tenantId = :tenantId")
    public void deleteCompanyPackageByPackageIdAndTenantId(@Param(value="servicePackageId") long var1, @Param(value="tenantId") long var3);

    @Query(value="select csr.* from bss_company_service_rel csr left join bss_tenant t on csr.tenant_id = t.tenant_id left join bss_company c on csr.company_id = c.company_id left join bss_service_package sp on csr.service_package_id = sp.service_package_id where t.tenant_code = :tenantCode and c.tax_num = :taxNum and sp.service_package_code = :packageCode", nativeQuery=true)
    public List<CompanyServiceRel> findByTenantCodeAndTaxNumAndPackageCode(@Param(value="tenantCode") String var1, @Param(value="taxNum") String var2, @Param(value="packageCode") String var3);

    @Modifying(flushAutomatically=true)
    @Query(value="update CompanyServiceRel rel set rel.tenantId = :tenantId where rel.id in (:companyPackageIds)")
    public void batchUpdateTenant(@Param(value="companyPackageIds") List<Long> var1, @Param(value="tenantId") Long var2);
}

