/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.entity.Resource;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ResourceDao
extends JpaRepository<Resource, Long>,
JpaSpecificationExecutor<Resource> {
    @Modifying(clearAutomatically=true)
    @Query(value="delete from Resource r where r.resourceId = :resourceId")
    public void deleteById(@Param(value="resourceId") Long var1);

    @EntityGraph(value="Resource.graph", type=EntityGraph.EntityGraphType.FETCH)
    public Page<Resource> findAll(Specification<Resource> var1, Pageable var2);

    public List<Resource> findByParentId(long var1);

    public List<Resource> findAll();

    @Modifying(clearAutomatically=true)
    @Query(value="update Resource r set r.status = :status where r.resourceId = :id")
    public int updateStatus(@Param(value="id") long var1, @Param(value="status") int var3);

    public List<Resource> findByAppIdAndResourceCode(Long var1, String var2);

    @Query(value="select sr.* from sys_resource sr where sr.resource_id in (select srrr.resource_id from sys_resourceset_resource_rel srrr where srrr.resourceset_id in (select srrr2.resouseset_id from sys_role_resourceset_rel srrr2 where srrr2.role_id = :roleId)) and sr.status = 1", nativeQuery=true)
    public List<Resource> findAllByRoleId(@Param(value="roleId") long var1);

    @Query(value="select sr.* from sys_resource sr where sr.resource_id in (select srrr.resource_id from sys_resourceset_resource_rel srrr where srrr.resourceset_id in (select srrr2.resouseset_id from sys_role_resourceset_rel srrr2 where srrr2.role_id in :roleIds)) and sr.status = 1", nativeQuery=true)
    public List<Resource> findAllByRoleIds(@Param(value="roleIds") Collection<Long> var1);

    @Query(value="select * from sys_resource where resource_id in(SELECT DISTINCT r.resource_id FROM sys_resource AS r INNER JOIN sys_resourceset_resource_rel AS rel ON r.resource_id = rel.resource_id INNER JOIN sys_resourceset AS rs ON rel.resourceset_id = rs.resourceset_id WHERE rs.resourceset_id IN (:resourcesetIds) and r.`status` = 1 and rs.`status` = 1)", nativeQuery=true)
    public List<Resource> findByResourcesetIds(@Param(value="resourcesetIds") Collection<Long> var1);
}

