/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao.impl;

import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.dao.CustomizedCompanyDao;
import com.xforceplus.domain.company.CompanyPackage;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class CustomizedCompanyDaoImpl
implements CustomizedCompanyDao {
    private static final Logger logger = LoggerFactory.getLogger(CustomizedCompanyDaoImpl.class);
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<CompanyPackage> findPackages(CompanyModel.Request.CompanyPackageQuery query, Pageable pageable) {
        StringBuilder selectBuilder = new StringBuilder("select new com.xforceplus.domain.company.CompanyPackage(csr.id, csr.tenantId, csr.tenant.tenantCode, csr.tenant.tenantName, csr.companyId, csr.company.companyName, csr.company.taxNum, csr.status, csr.createUserName, csr.createTime) from com.xforceplus.entity.CompanyServiceRel csr");
        StringBuilder countBuilder = new StringBuilder("select count(distinct csr.companyId) from com.xforceplus.entity.CompanyServiceRel csr join csr.tenant join csr.company");
        StringBuilder groupByBuilder = new StringBuilder(" group by csr.companyId");
        StringBuilder queryBuilder = new StringBuilder();
        if (query != null) {
            boolean hasParam = false;
            if (query.getCompanyId() != null) {
                queryBuilder.append(" where");
                queryBuilder.append(" csr.companyId = :companyId");
                hasParam = true;
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.company.taxNum = :taxNum");
                hasParam = true;
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.company.companyName like :companyName");
                hasParam = true;
            }
            if (query.getTenantId() != null) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.tenantId = :tenantId");
                hasParam = true;
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.tenant.tenantCode = :tenantCode");
                hasParam = true;
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.tenant.tenantName like :tenantName");
                hasParam = true;
            }
            if (query.getServicePackageId() != null && query.getServicePackageId() > 0L) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.servicePackage.servicePackageId = :servicePackageId");
                hasParam = true;
            }
            if (StringUtils.isNotBlank((CharSequence)query.getServicePackageName())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.servicePackage.servicePackageName like :servicePackageName");
                hasParam = true;
            }
            if (query.getStatus() != null) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.status = :status");
            }
        }
        selectBuilder.append((CharSequence)queryBuilder).append((CharSequence)groupByBuilder).append(" order by csr.id desc");
        countBuilder.append((CharSequence)queryBuilder);
        String selectHql = selectBuilder.toString();
        logger.info("selectHQL = {}", (Object)selectHql);
        TypedQuery selectQuery = this.entityManager.createQuery(selectHql, CompanyPackage.class);
        String countHql = countBuilder.toString();
        logger.info("countHQL = {}", (Object)countHql);
        TypedQuery countQuery = this.entityManager.createQuery(countHql, Long.class);
        if (query != null) {
            if (query.getCompanyId() != null) {
                selectQuery.setParameter("companyId", (Object)query.getCompanyId());
                countQuery.setParameter("companyId", (Object)query.getCompanyId());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                selectQuery.setParameter("taxNum", (Object)query.getTaxNum());
                countQuery.setParameter("taxNum", (Object)query.getTaxNum());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                selectQuery.setParameter("companyName", (Object)(query.getCompanyName() + "%"));
                countQuery.setParameter("companyName", (Object)(query.getCompanyName() + "%"));
            }
            if (query.getTenantId() != null) {
                selectQuery.setParameter("tenantId", (Object)query.getTenantId());
                countQuery.setParameter("tenantId", (Object)query.getTenantId());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                selectQuery.setParameter("tenantCode", (Object)query.getTenantCode());
                countQuery.setParameter("tenantCode", (Object)query.getTenantCode());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTenantName())) {
                selectQuery.setParameter("tenantName", (Object)(query.getTenantName() + "%"));
                countQuery.setParameter("tenantName", (Object)(query.getTenantName() + "%"));
            }
            if (query.getServicePackageId() != null && query.getServicePackageId() > 0L) {
                selectQuery.setParameter("servicePackageId", (Object)query.getServicePackageId());
                countQuery.setParameter("servicePackageId", (Object)query.getServicePackageId());
            }
            if (StringUtils.isNotBlank((CharSequence)query.getServicePackageName())) {
                selectQuery.setParameter("servicePackageName", (Object)("%" + query.getServicePackageName() + "%"));
                countQuery.setParameter("servicePackageName", (Object)("%" + query.getServicePackageName() + "%"));
            }
            if (query.getStatus() != null) {
                selectQuery.setParameter("status", (Object)query.getStatus());
                countQuery.setParameter("status", (Object)query.getStatus());
            }
        }
        long totalCount = (Long)countQuery.getSingleResult();
        logger.info("totalCount = {}", (Object)totalCount);
        int startIndex = pageable.getPageNumber() * pageable.getPageSize();
        if ((long)startIndex > totalCount) {
            return new PageImpl(new ArrayList(), pageable, totalCount);
        }
        selectQuery.setFirstResult(startIndex);
        selectQuery.setMaxResults(pageable.getPageSize());
        List list = selectQuery.getResultList();
        PageImpl page = new PageImpl(list, pageable, totalCount);
        return page;
    }
}

