/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao.impl;

import com.xforceplus.api.model.OrgModel;
import com.xforceplus.dao.CustomizedOrgStructDao;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.query.OrgQueryHelper;
import io.geewit.data.jpa.essential.utils.TupleQueryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.util.CollectionUtils;

public class CustomizedOrgStructDaoImpl
implements CustomizedOrgStructDao {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<OrgStruct> findDescendantsById(long orgId) {
        TypedQuery subQuery = this.entityManager.createQuery("select o.parentIds from OrgStruct o where o.orgId = :orgId", String.class);
        subQuery.setParameter("orgId", (Object)orgId);
        subQuery.setFirstResult(0).setMaxResults(1);
        String parentIds = (String)subQuery.getSingleResult();
        if (StringUtils.isEmpty((CharSequence)parentIds)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5b9e\u4f53");
        }
        TypedQuery query = this.entityManager.createQuery("select o from OrgStruct o where o.parentIds like :parentIds order by o.parentIds", OrgStruct.class);
        query.setParameter("parentIds", (Object)(parentIds + "%"));
        return query.getResultList();
    }

    @Override
    public Page<Tuple> findTuples(OrgModel.Request.Query query, Pageable pageable) {
        Sort sort;
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery tupleCriteriaQuery = criteriaBuilder.createTupleQuery();
        Root tupleRoot = tupleCriteriaQuery.from(OrgStruct.class);
        Predicate predicate = OrgQueryHelper.queryTuplePredicate(query, (Root<OrgStruct>)tupleRoot, (CriteriaQuery<Tuple>)tupleCriteriaQuery, criteriaBuilder);
        if (predicate != null) {
            tupleCriteriaQuery.where((Expression)predicate);
        }
        Sort sort2 = sort = pageable.isPaged() ? pageable.getSort() : Sort.unsorted();
        if (sort.isSorted()) {
            List toOrders;
            ArrayList orders = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)tupleCriteriaQuery.getOrderList())) {
                orders.addAll(tupleCriteriaQuery.getOrderList());
            }
            if (!CollectionUtils.isEmpty((Collection)(toOrders = QueryUtils.toOrders((Sort)sort, (From)tupleRoot, (CriteriaBuilder)criteriaBuilder)))) {
                orders.addAll(toOrders);
            }
            if (!CollectionUtils.isEmpty(orders)) {
                tupleCriteriaQuery.orderBy(orders);
            }
        }
        TypedQuery listQuery = this.entityManager.createQuery(tupleCriteriaQuery);
        if (pageable.isPaged()) {
            listQuery.setFirstResult((int)pageable.getOffset());
            listQuery.setMaxResults(pageable.getPageSize());
        }
        List results = listQuery.getResultList();
        CriteriaBuilder countCriteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countCriteriaQuery = countCriteriaBuilder.createQuery(Long.class);
        Root countRoot = countCriteriaQuery.from(OrgStruct.class);
        Predicate countPredicate = OrgQueryHelper.queryCountPredicate(query, (Root<OrgStruct>)countRoot, (CriteriaQuery<Long>)countCriteriaQuery, countCriteriaBuilder);
        if (pageable.isPaged()) {
            return PageableExecutionUtils.getPage((List)results, (Pageable)pageable, () -> TupleQueryUtils.executeCountQuery((TypedQuery)TupleQueryUtils.getCountQuery((EntityManager)this.entityManager, (Root)countRoot, (CriteriaQuery)countCriteriaQuery, (CriteriaBuilder)countCriteriaBuilder, (Predicate)countPredicate)));
        }
        return new PageImpl(results);
    }
}

