/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao.impl;

import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.dao.CustomizedOrgVirtualNodeDao;
import com.xforceplus.data.transform.UnderlineToBeanResultTransformer;
import com.xforceplus.domain.orgVirtual.OrgVirtualTreeNode;
import com.xforceplus.entity.OrgVirtualNode;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class CustomizedOrgVirtualNodeDaoImpl
implements CustomizedOrgVirtualNodeDao {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<OrgVirtualTreeNode> treeNodeList(Long tenantId, Long typeId) {
        StringBuilder selectBuilder = new StringBuilder("select DISTINCT  a.org_virtual_node_id as `key`, b.org_code as orgCode, b.org_name as orgName, b.short_name as shortName, b.org_desc as orgDesc, a.parent_id as pid from sys_org_virtual_node a  left join sys_org_virtual b on a.org_virtual_id=b.org_virtual_id  where a.tenant_id=:tenantId  and a.node_type_id=:typeId  order by a.parent_ids");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", (Object)tenantId);
        selectQuery.setParameter("typeId", (Object)typeId);
        return ((NativeQuery)selectQuery.unwrap(NativeQuery.class)).addScalar("key", (Type)StandardBasicTypes.LONG).addScalar("orgCode", (Type)StandardBasicTypes.STRING).addScalar("orgName", (Type)StandardBasicTypes.STRING).addScalar("shortName", (Type)StandardBasicTypes.STRING).addScalar("orgDesc", (Type)StandardBasicTypes.STRING).addScalar("pid", (Type)StandardBasicTypes.LONG).setResultTransformer(Transformers.aliasToBean(OrgVirtualTreeNode.class)).getResultList();
    }

    @Override
    public List<OrgVirtualModel.Response.Model> listByUserId(Long typeId, Long userId, Long tenantId) {
        StringBuilder selectBuilder = new StringBuilder("SELECT  b.org_virtual_node_id,  b.parent_id,  b.parent_ids,  c.control_flag,  a.*  FROM  sys_org_virtual a  LEFT JOIN sys_org_virtual_node b ON a.org_virtual_id = b.org_virtual_id  LEFT JOIN sys_org_virtual_node_user_rel c ON b.org_virtual_node_id = c.org_virtual_node_id  WHERE  b.node_type_id =:typeId  AND c.user_id =:userId  AND a.tenant_id =:tenantId order by b.parent_ids");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", (Object)tenantId);
        selectQuery.setParameter("typeId", (Object)typeId);
        selectQuery.setParameter("userId", (Object)userId);
        UnderlineToBeanResultTransformer transformer = new UnderlineToBeanResultTransformer(OrgVirtualModel.Response.Model.class);
        return ((NativeQueryImpl)selectQuery.unwrap(NativeQueryImpl.class)).setResultTransformer((ResultTransformer)transformer).getResultList();
    }

    @Override
    public List<OrgVirtualModel.Response.Model> listByNodeId(OrgVirtualNode node) {
        StringBuilder selectBuilder = new StringBuilder("SELECT  b.org_virtual_node_id,  b.parent_id,  b.parent_ids,  b.node_type_id,  a.*  FROM  sys_org_virtual a  LEFT JOIN sys_org_virtual_node b ON a.org_virtual_id = b.org_virtual_id  WHERE  a.tenant_id =:tenantId  AND b.parent_ids LIKE :parentIds order by b.parent_ids");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("tenantId", (Object)node.getTenantId());
        selectQuery.setParameter("parentIds", (Object)(node.getParentIds() + "%"));
        UnderlineToBeanResultTransformer transformer = new UnderlineToBeanResultTransformer(OrgVirtualModel.Response.Model.class);
        return ((NativeQueryImpl)selectQuery.unwrap(NativeQueryImpl.class)).setResultTransformer((ResultTransformer)transformer).getResultList();
    }
}

