/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.xforceplus.domain.client.ClientDto;
import com.xforceplus.jpa.converter.GrantTypeConverter;
import com.xforceplus.jpa.listener.ClientPersistenceListener;
import io.geewit.oltu.oauth2.common.message.types.GrantType;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

@DynamicInsert
@DynamicUpdate
@EntityListeners(value={ClientPersistenceListener.class})
@Entity
@Table(name="bss_client")
public class Client
extends ClientDto
implements Serializable {
    @Column(name="client_id")
    public String getClientId() {
        return this.clientId;
    }

    @Column(name="secret")
    public String getSecret() {
        return this.secret;
    }

    @Column(name="client_name")
    public String getClientName() {
        return this.clientName;
    }

    @Column(name="client_app_id")
    public Integer getAppId() {
        return this.appId;
    }

    @Column(name="scope")
    public String getScope() {
        return this.scope;
    }

    @Convert(converter=GrantTypeConverter.class)
    @Column(name="grant_type")
    public GrantType getGrantType() {
        return this.grantType;
    }

    @Column(name="redirect_uri")
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Column(name="extension")
    public String getExtension() {
        return this.extension;
    }

    @Column(name="status")
    public Boolean getStatus() {
        return this.status;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="create_time")
    public Date getCreateTime() {
        return this.createTime;
    }

    @Transient
    public List<Long> getTenantIds() {
        return this.tenantIds;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="SnowflakeGenerator")
    @GenericGenerator(name="SnowflakeGenerator", strategy="io.geewit.data.jpa.essential.id.SnowflakeGenerator")
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String toString() {
        return "Client{clientId='" + this.clientId + '\'' + ", secret='" + this.secret + '\'' + ", clientName='" + this.clientName + '\'' + ", appId=" + this.appId + ", scope='" + this.scope + '\'' + ", grantType=" + this.grantType + ", redirectUri='" + this.redirectUri + '\'' + ", extension='" + this.extension + '\'' + ", status=" + this.status + ", createTime=" + this.createTime + ", tenantIds=" + this.tenantIds + '}';
    }
}

